<?php

	add_action( 'init', 'madingcat_blog', 0 );
	function madingcat_blog() {
	    $labels = array(
    	    'name'              => __( 'Blog Category', 'sekolahpro' ),
	        'singular_name'     => __( 'Blog Category', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Blog Category', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('blog-kat',array('blog'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_blogkat',
                'edit_terms'    => 'edit_blogkat',
                'delete_terms'  => 'delete_blogkat',
                'assign_terms'  => 'assign_blogkat',
            )
	  ));
	}
	
	add_action( 'init', 'status_guru', 0 );
	function status_guru() {
	    $labels = array(
    	    'name'              => __( 'Employee Status', 'sekolahpro' ),
	        'singular_name'     => __( 'Employee Status', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Employee Status', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('stts',array('gtk','ustadz','dosen'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_stts',
                'edit_terms'    => 'edit_stts',
                'delete_terms'  => 'delete_stts',
                'assign_terms'  => 'assign_stts',
            )
	  ));
	}
	
	add_action( 'init', 'jenis_guru', 0 );
	function jenis_guru() {
	    $labels = array(
    	    'name'              => __( 'Functional Position', 'sekolahpro' ),
	        'singular_name'     => __( 'Functional Position', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Functional Position', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('jab',array('gtk','ustadz','dosen'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_jab',
                'edit_terms'    => 'edit_jab',
                'delete_terms'  => 'delete_jab',
                'assign_terms'  => 'assign_jab',
            )
	  ));
	}
	
	add_action( 'init', 'level_guru', 0 );
	function level_guru() {
	    $labels = array(
    	    'name'              => __( 'Structure Level', 'sekolahpro' ),
	        'singular_name'     => __( 'Structure Level', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Structure Level', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('structure',array('gtk','ustadz','dosen'), array(
	        'hierarchical'       => true,
	        'labels'             => $labels,
	        'show_ui'            => true,
	        'show_admin_column'  => true,
	        'query_var'          => false, // Mencegah akses via URL query
	    	'show_in_rest'       => true,
			'publicly_queryable' => false, // Mencegah halaman arsip
            'rewrite'            => false, // Menonaktifkan permalink arsip
			'capabilities' => array(
                'manage_terms'  => 'manage_structure',
                'edit_terms'    => 'edit_structure',
                'delete_terms'  => 'delete_structure',
                'assign_terms'  => 'assign_structure',
            )
	  ));
	}
	
	
	add_action( 'init', 'siswa_kelas', 0 );
	function siswa_kelas() {
	    $labels = array(
    	    'name'              => __( 'Class / Study', 'sekolahpro' ),
	        'singular_name'     => __( 'Class / Study', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Class / Study', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('kelas',array('siswa', 'santri'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_kel',
                'edit_terms'    => 'edit_kel',
                'delete_terms'  => 'delete_kel',
                'assign_terms'  => 'assign_kel',
            )
	  ));
	}
	
	add_action( 'init', 'mhs_fakultas', 0 );
	function mhs_fakultas() {
	    $labels = array(
    	    'name'              => __( 'Faculty / Semester', 'sekolahpro' ),
	        'singular_name'     => __( 'Faculty / Semester', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Faculty / Semester', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('fakultas',array('mahasiswa'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_fak',
                'edit_terms'    => 'edit_fak',
                'delete_terms'  => 'delete_fak',
                'assign_terms'  => 'assign_fak',
            )
	  ));
	}

	add_action( 'init', 'cat_download', 0 );
	function cat_download() {
	    $labels = array(
    	    'name'              => __( 'Download Category', 'sekolahpro' ),
	        'singular_name'     => __( 'Download Category', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Download Category', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('cat-download',array('download'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_catdown',
                'edit_terms'    => 'edit_catdown',
                'delete_terms'  => 'delete_catdown',
                'assign_terms'  => 'assign_catdown',
            )
	  ));
	}
	add_action( 'init', 'type_download', 0 );
	function type_download() {
	    $labels = array(
    	    'name'              => __( 'Type File Download', 'sekolahpro' ),
	        'singular_name'     => __( 'Type File Download', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Type File Download', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('type-file',array('download'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_typedown',
                'edit_terms'    => 'edit_typedown',
                'delete_terms'  => 'delete_typedown',
                'assign_terms'  => 'assign_typedown',
            )
	  ));
	}
	
	add_action( 'init', 'materi_kelas', 0 );
	function materi_kelas() {
	    $labels = array(
    	    'name'              => __( 'Class / Study', 'sekolahpro' ),
	        'singular_name'     => __( 'Class / Study', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Class / Study', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('tugas',array('materi'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_level',
                'edit_terms'    => 'edit_level',
                'delete_terms'  => 'delete_level',
                'assign_terms'  => 'assign_level',
            )
	  ));
	}
	
	add_action( 'init', 'materi_mapel', 0 );
	function materi_mapel() {
	    $labels = array(
    	    'name'              => __( 'Subject', 'sekolahpro' ),
	        'singular_name'     => __( 'Subject', 'sekolahpro' ),
	        'search_items'      => __( 'Search Item', 'sekolahpro' ),
    	    'all_items'         => __( 'All Items', 'sekolahpro' ),
    	    'parent_item'       => null,
    	    'parent_item_colon' => null,
    	    'edit_item'         => __( 'Edit Item', 'sekolahpro' ),
    	    'update_item'       => __( 'Update Item', 'sekolahpro' ),
    	    'add_new_item'      => __( 'Add New Item', 'sekolahpro' ),
    	    'new_item_name'     => __( 'New Item Name', 'sekolahpro' ),
    	    'menu_name'         => __( 'Subject', 'sekolahpro' ),
	    );   
	  
	    register_taxonomy('mapel',array('materi'), array(
	        'hierarchical'      => true,
	        'labels'            => $labels,
	        'show_ui'           => true,
	        'show_admin_column' => true,
	        'query_var'         => true,
	    	'show_in_rest'      => true,
			'capabilities' => array(
                'manage_terms'  => 'manage_mapel',
                'edit_terms'    => 'edit_mapel',
                'delete_terms'  => 'delete_mapel',
                'assign_terms'  => 'assign_mapel',
            )
	  ));
	}
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'pos_tutorial', 1);
	
	function pos_tutorial() {
	    add_meta_box('postutorial', esc_html__('Tutorial', 'sekolahpro'), 'postutorial', 'post', 'normal', 'default');
	}

	function postutorial() { ?>
		    
		<div class="mading_metabox">
		    <iframe width="100%" height="400" src="<?php echo esc_url( 'https://ciuss.com/tuts-post/' ); ?>" frameborder="0" allowfullscreen></iframe>
		</div>
    
	<?php }
	}
	
	// Tambahkan menu di admin untuk halaman ekspor
	add_action('admin_menu', 'add_export_page');

	function add_export_page() {
	    if ( get_theme_mod('sekolah_type') == "akademi" ) {
			$tipesiswa = 'mahasiswa';
			$export_text = esc_html__( 'Export Mahasiswa (CSV)', 'sekolahpro' );
		} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
			$tipesiswa = 'santri';
			$export_text = esc_html__( 'Export Santri (CSV)', 'sekolahpro' );
		} else {
			$tipesiswa = 'siswa';
			$export_text = esc_html__( 'Export Siswa (CSV)', 'sekolahpro' );
		}
    	add_submenu_page(
    	    'edit.php?post_type='.$tipesiswa,
    	    $export_text,
    	    $export_text,
    	    'manage_options',
    	    'export-posts',
    	    'export_siswa_page'
    	);
	}

	// Fungsi untuk menampilkan halaman ekspor
	function export_siswa_page() {
	    ?>
    	<div class="wrap">
    	    <h2><?php echo esc_html__( 'Export Data (CSV)', 'sekolahpro' ); ?></h2>
    	    <form method="post">
    	        <input type="hidden" name="export_siswa" value="true" />
    	        <?php submit_button(esc_html__( 'Export Data', 'sekolahpro' )); ?>
    	    </form>
    	</div>
    	<?php
	}

	add_action('admin_init', 'export_siswa');

function export_siswa() {
    if (isset($_POST['export_siswa']) && $_POST['export_siswa'] == 'true') {
        global $wpdb;

        $posts = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'siswa' AND post_status = 'publish'");

        if ($posts) {
            $csv_output = "ID,Title,Date,Masuk,NISN,Sex,Kota,Lahir,Agama,Alamat,Telp,Email,Anak Ke,Dari,Ayah,Ibu,Alamat,Kelas\n"; // Menambahkan header untuk custom taxonomy bulan dan tahun

            foreach ($posts as $post) {
                $post_id = $post->ID;
                $post_title = $post->post_title;
                $post_date = $post->post_date;

                // Ambil data custom field
                $mas  = get_post_meta($post->ID, '_mas', true);
	        	$nisn = get_post_meta($post->ID, '_nisn', true);
	            $sex  = get_post_meta($post->ID, '_sex', true);
	        	$tmpt = get_post_meta($post->ID, '_tmpt', true);
	        	$tgl  = get_post_meta($post->ID, '_tgl', true);
	        	$rel  = get_post_meta($post->ID, '_rel', true);
	        	$add  = get_post_meta($post->ID, '_add', true);
	        	$telp = get_post_meta($post->ID, '_telp', true);
	        	$mail = get_post_meta($post->ID, '_mail', true);
	        	$anak = get_post_meta($post->ID, '_anak', true);
	        	$dari = get_post_meta($post->ID, '_dari', true);
	        	$ayah = get_post_meta($post->ID, '_ayah', true);
	        	$ibu  = get_post_meta($post->ID, '_ibu', true);
	        	$almt = get_post_meta($post->ID, '_almt', true);

                // Ambil custom taxonomy "kelas"
				if ( get_theme_mod('sekolah_type') == "akademi" ) {
                   $kelas_terms = wp_get_post_terms($post_id, 'fakultas');
				} else {
					$kelas_terms = wp_get_post_terms($post_id, 'kelas');
				}
                $kelas = !empty($kelas_terms) ? $kelas_terms[0]->name : '';

                // Format baris CSV
                $csv_output .= "$post_id,\"$post_title\",\"$post_date\",\"$mas\",\"$nisn\",\"$sex\",\"$tmpt\",\"$tgl\",\"$rel\",\"$add\",\"$telp\",\"$mail\",\"$anak\",\"$dari\",\"$ayah\",\"$ibu\",\"$almt\",\"$kelas\"\n";
            }

            // Header untuk men-download file CSV
			if ( get_theme_mod('sekolah_type') == "akademi" ) {
				$tipesiswa = 'mahasiswa';
			} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
				$tipesiswa = 'santri';
			} else {
				$tipesiswa = 'siswa';
			}
			$dates = date('D-m-Y');
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename=daftar-$tipesiswa-$dates.csv");
            header("Pragma: no-cache");
            header("Expires: 0");

            // Keluarkan data CSV
            echo $csv_output;
            exit;
        }
    }
}


// Tambahkan menu di admin untuk halaman impor
add_action('admin_menu', 'add_import_page');

function add_import_page() {
	if ( get_theme_mod('sekolah_type') == "akademi" ) {
		$tipesiswa = 'mahasiswa';
		$import_text = esc_html__( 'Import Mahasiswa (CSV)', 'sekolahpro' );
	} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
		$tipesiswa = 'santri';
		$import_text = esc_html__( 'Import Santri (CSV)', 'sekolahpro' );
	} else {
		$tipesiswa = 'siswa';
		$import_text = esc_html__( 'Import Siswa (CSV)', 'sekolahpro' );
	}
	add_submenu_page(
        'edit.php?post_type='.$tipesiswa,
        $import_text,
        $import_text,
        'manage_options',
        'import-posts',
        'import_siswa_page'
    );
}

// Fungsi untuk menampilkan halaman impor
function import_siswa_page() {
    ?>
    <div class="wrap">
        <h2><?php echo esc_html__( 'Import Data (CSV)', 'sekolahpro' ); ?></h2>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="csv_file" accept=".csv" />
            <br />
            <?php submit_button(esc_html__( 'Import Data', 'sekolahpro' )); ?>
        </form>
    </div>
    <?php
}

add_action('admin_init', 'import_data_siswa');

function import_data_siswa() {
    if (isset($_FILES['csv_file'])) {
		
		$file_name = $_FILES['csv_file']['name'];
        $file_tmp = $_FILES['csv_file']['tmp_name'];
        $file_size = $_FILES['csv_file']['size'];
        $file_ext = strtolower(end(explode('.', $file_name)));
        
        // Validasi ekstensi file
        $allowed_ext = array('csv');
        if (!in_array($file_ext, $allowed_ext)) {
            echo '<div class="error"><p>';
            echo esc_html__('Only CSV files are allowed.', 'sekolahpro');
            echo '</p></div>';
            return;
        }
        
        // Validasi tipe mime
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime_type = finfo_file($finfo, $file_tmp);
        finfo_close($finfo);
        $allowed_mime = array('text/csv', 'text/plain');
        if (!in_array($mime_type, $allowed_mime)) {
            echo '<div class="error"><p>';
            echo esc_html__('Invalid file type. Please upload a CSV file.', 'sekolahpro');
            echo '</p></div>';
            return;
        }
		
        if ($_FILES['csv_file']['error'] == 0) {
            $csv_file = $_FILES['csv_file']['tmp_name'];
            $csv_data = array_map('str_getcsv', file($csv_file));

            $success_count = 0;
            $failure_count = 0;

            foreach ($csv_data as $key => $row) {
                if ($key == 0) continue; // Skip header row

                // Extract data from CSV row
                $post_title   = $row[1];
                $post_date    = $row[2];
                $mas          = $row[3];
                $nisn         = $row[4];
                $sex          = $row[5];
                $tmpt         = $row[6];
                $tgl          = $row[7];
                $rel          = $row[8];
				$add          = $row[9];
				$telp         = $row[10];
                $mail         = $row[11];
                $anak         = $row[12];
                $dari         = $row[13];
                $ayah         = $row[14];
                $ibu          = $row[15];
                $almt         = $row[16];
				$kelas        = $row[17];

                // Prepare post data
				if ( get_theme_mod('sekolah_type') == "akademi" ) {
					$tipesiswa = 'mahasiswa';
				} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
					$tipesiswa = 'santri';
				} else {
					$tipesiswa = 'siswa';
				}
                $post_data = array(
                    'post_title'   => $post_title,
                    'post_content' => '', // You may customize this based on your CSV structure
                    'post_status'  => 'publish',
                    'post_type'    => $tipesiswa,
                    'post_date'    => $post_date,
                );

                // Insert post
                $post_id = wp_insert_post($post_data);

                if ($post_id) {
				
                    // Set custom fields
					if (!empty($mas)) {
                        update_post_meta($post_id, '_mas', $mas);
					}
					if (!empty($nisn)) {
				    	update_post_meta($post_id, '_nisn', $nisn);
					}
					if (!empty($sex)) {
                        update_post_meta($post_id, '_sex', $sex);
					}
					if (!empty($tmpt)) {
                        update_post_meta($post_id, '_tmpt', $tmpt);
					}
					if (!empty($tgl)) {
                        update_post_meta($post_id, '_tgl', $tgl);
					}
					if (!empty($rel)) {
                        update_post_meta($post_id, '_rel', $rel);
					}
					if (!empty($add)) {
                        update_post_meta($post_id, '_add', $add);
					}
					if (!empty($telp)) {
                        update_post_meta($post_id, '_telp', $telp);
					}
					if (!empty($mail)) {
                        update_post_meta($post_id, '_mail', $mail);
					}
					if (!empty($anak)) {
                        update_post_meta($post_id, '_anak', $anak);
					}
					if (!empty($dari)) {
                        update_post_meta($post_id, '_dari', $dari);
					}
					if (!empty($ayah)) {
                        update_post_meta($post_id, '_ayah', $ayah);
					}
					if (!empty($ibu)) {
                        update_post_meta($post_id, '_ibu', $ibu);
					}
					if (!empty($almt)) {
                        update_post_meta($post_id, '_almt', $almt);
					}

                    // Set taxonomy 'kelas'
                    if (!empty($kelas)) {
						if ( get_theme_mod('sekolah_type') == "akademi" ) {
                            $kelas_id = wp_create_term($kelas, 'fakultas');
                            if (!is_wp_error($kelas_id) && isset($kelas_id['term_id'])) {
                                wp_set_post_terms($post_id, $kelas_id['term_id'], 'fakultas');
                            }
						} else {
							$kelas_id = wp_create_term($kelas, 'kelas');
                            if (!is_wp_error($kelas_id) && isset($kelas_id['term_id'])) {
                                wp_set_post_terms($post_id, $kelas_id['term_id'], 'kelas');
                            }
						}
                    }

                    $success_count++;
                } else {
                    $failure_count++;
                }
            }

            // Show message after import
			echo '<div class="updated"><p>';
			echo sprintf( esc_html__('Successfully imported %s data. Failed to import %s data.', 'sekolahpro'), $success_count, $failure_count );
            echo '</p></div>';
		} else {
			echo '<div class="updated"><p>';
			echo esc_html__( 'Error uploading CSV file.', 'sekolahpro' );
			echo '</p></div>';
        }
    }
}