<?php
     
	
	register_post_type( 'ustadz',		
	array(			
	    'menu_icon' => 'dashicons-businessman',
	    'labels'          => array(				
	    'name'                => __( 'Ustadz / Ustadzah', 'sekolahpro' ),				
	    'singular_name'       => __( 'Ustadz / Ustadzah', 'sekolahpro' ),        
	    'add_new'             => __( 'Add New', 'sekolahpro'  ),	
	    'add_new_item'        => __( 'Add New Item', 'sekolahpro'  ),	
	    'edit'                => __( 'Edit', 'sekolahpro'  ),	 
	    'edit_item'           => __( 'Edit Item', 'sekolahpro'  ),	
	    'new_item'            => __( 'New Item', 'sekolahpro'  ),	
	    'view'                => __( 'View', 'sekolahpro'  ),	
	    'view_item'           => __( 'View Item', 'sekolahpro'  ),	
	    'search_items'        => __( 'Search Item', 'sekolahpro'  ),	
	    'not_found'           => __( 'Item not found', 'sekolahpro'  ),	
	    'not_found_in_trash'  => __( 'Item not found in Trash', 'sekolahpro'  ),	
	    'parent'              => __( 'Parent Super Duper', 'sekolahpro'  ),	
        'featured_image'      => __( 'Photo 300 x 400', 'sekolahpro' ),		
	    ),		                	
	    	'public'               => true,           					            
	    	'has_archive'          => true,        			            
	    	'supports'             => array( 'title', 'thumbnail', 'editor', 'author'),        			            
	    	'exclude_from_search'  => false, 	 
	    	'show_in_rest'         => true,
			'capabilities' => array(
                'edit_post'                 => 'edit_ustadz',
				'edit_posts'                => 'edit_ustadzs',
                'edit_others_posts'         => 'edit_other_ustadzs',
				'edit_private_posts'        => 'edit_private_ustadzs',
				'edit_published_posts'      => 'edit_published_ustadzs',
				'read_post'                 => 'read_ustadz',
				'read_private_posts'        => 'read_private_ustadzs',
				'publish_posts'             => 'publish_ustadzs',
				'delete_post'               => 'delete_ustadz',
                'delete_posts'              => 'delete_ustadzs',
                'delete_private_posts'      => 'delete_private_ustadzs',
				'delete_others_posts'       => 'delete_others_ustadzs',
                'delete_published_posts'    => 'delete_published_ustadzs',
            ),
			'map_meta_cap' => true
		 )	
    );
	
	if ( get_theme_mod( 'hide_tutor' ) !== 'off' ) {
	add_action('admin_init', 'ustadz_tutorial', 1);
	 
	function ustadz_tutorial() {
	    add_meta_box('ustadztutorial', __('Tutorial', 'sekolahpro'), 'ustadztutorial', 'ustadz', 'normal', 'default');
	}

	function ustadztutorial() { ?>
		    
		<div class="mading_metabox">
		    <?php echo wp_oembed_get( 'https://www.youtube.com/watch?v=EyH0_THjxh0' ); ?>
		</div>
    
	<?php }
	}
	
	add_action('admin_init', 'guru', 1);
	
	function guru() {
	    add_meta_box('guru_data', __('Biodata', 'sekolahpro'), 'guru_data', 'ustadz', 'normal', 'default');
	}

	function guru_data($post) {
	    global $post;
	    echo '<input type="hidden" name="gtk_noncename" id="gtk_noncename" value="' . esc_attr( wp_create_nonce( plugin_basename(__FILE__) ) ) . '" />';

	    $nik      = get_post_meta($post->ID, '_nik', true);
		$nip      = get_post_meta($post->ID, '_nip', true);
		$nuptk    = get_post_meta($post->ID, '_nuptk', true);
		$mas      = get_post_meta($post->ID, '_mas', true);
	    $sex      = get_post_meta($post->ID, '_sex', true);
		$tmpt     = get_post_meta($post->ID, '_tmpt', true);
		$tgl      = get_post_meta($post->ID, '_tgl', true);
		$rel      = get_post_meta($post->ID, '_rel', true);
		
		$add      = get_post_meta($post->ID, '_add', true);
		$telp     = get_post_meta($post->ID, '_telp', true);
		$waguru   = get_post_meta($post->ID, '_waguru', true);
		$mail     = get_post_meta($post->ID, '_mail', true);
		$madingfb = get_post_meta($post->ID, '_madingfb', true);
		$madingtw = get_post_meta($post->ID, '_madingtw', true);
		$madingig = get_post_meta($post->ID, '_madingig', true);
		
		?>

		<div class="mading_metabox">
		
		    <label><?php echo esc_html_e( 'NIK', 'sekolahpro' ); ?></label>
	        <input type="text" name="_nik" value="<?php echo esc_attr( $nik ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'NIP', 'sekolahpro' ); ?></label>
	        <input type="text" name="_nip" value="<?php echo esc_attr( $nip ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'NUPTK', 'sekolahpro' ); ?></label>
			<input type="text" name="_nuptk" value="<?php echo esc_attr( $nuptk ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Active Since', 'sekolahpro' ); ?></label>
	        <input type="date" name="_mas" value="<?php echo esc_attr( $mas ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Gender', 'sekolahpro' ); ?></label>
	        <input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Laki-Laki' ) ?> value="Laki-Laki"/><span class="stt"><?php _e('Male', 'sekolahpro'); ?></span>
			<input type="radio" name="_sex" <?php checked( esc_attr( $sex ), 'Perempuan' ) ?> value="Perempuan"/><span class="stt"><?php _e('Female', 'sekolahpro'); ?></span>
			
			<label><?php echo esc_html_e( 'Birth Place', 'sekolahpro' ); ?></label>
			<input type="text" name="_tmpt" value="<?php echo esc_attr( $tmpt ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Birth Date', 'sekolahpro' ); ?></label>
			<input type="date" name="_tgl" value="<?php echo esc_attr( $tgl ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Religion : (Islam, Kristen, Katholik, Hindu, Budha, Konghucu, etc)', 'sekolahpro' ); ?></label>
			<input type="text" name="_rel" value="<?php echo esc_attr( $rel ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Address', 'sekolahpro' ); ?></label>
			<input type="text" name="_add" value="<?php echo esc_attr( $add ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Phone', 'sekolahpro' ); ?></label>
			<input type="text" name="_telp" value="<?php echo esc_attr( $telp ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'WhatsApp', 'sekolahpro' ); ?></label>
			<input type="text" name="_waguru" placeholder="<?php echo esc_attr_e( '62...', 'sekolahpro' ); ?>" value="<?php echo esc_attr( $waguru ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Email', 'sekolahpro' ); ?></label>
			<input type="text" name="_mail" value="<?php echo esc_attr( $mail ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Facebook', 'sekolahpro' ); ?></label>
			<input type="text" name="_madingfb" value="<?php echo esc_attr( $madingfb ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Twitter', 'sekolahpro' ); ?></label>
			<input type="text" name="_madingtw" value="<?php echo esc_attr( $madingtw ); ?>" class="widefat" />
			
			<label><?php echo esc_html_e( 'Instagram', 'sekolahpro' ); ?></label>
			<input type="text" name="_madingig" value="<?php echo esc_attr( $madingig ); ?>" class="widefat" />
			
		</div>
	<?php }
	
	function guru_data_meta($post_id, $post) {

	    if ( ! isset( $_POST['gtk_noncename'] ) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['gtk_noncename'] ) ), plugin_basename(__FILE__) )) {
	    return $post_id;
	    }
	    if ( !current_user_can( 'edit_post', $post_id ))

	        return $post_id;

	    $madingguru['_nik']      = isset($_POST['_nik']) ? sanitize_text_field(wp_unslash( $_POST['_nik'] ) ) : '' ;
		$madingguru['_nip']      = isset($_POST['_nip']) ? sanitize_text_field(wp_unslash( $_POST['_nip'] ) ) : '' ;
		$madingguru['_nuptk']    = isset($_POST['_nuptk']) ? sanitize_text_field(wp_unslash( $_POST['_nuptk'] ) ) : '' ;
		$madingguru['_mas']      = isset($_POST['_mas']) ? sanitize_text_field(wp_unslash( $_POST['_mas'] ) ) : '' ;
		$madingguru['_sex']      = isset($_POST['_sex']) ? sanitize_text_field(wp_unslash( $_POST['_sex'] ) ) : '' ;
		$madingguru['_tmpt']     = isset($_POST['_tmpt']) ? sanitize_text_field(wp_unslash( $_POST['_tmpt'] ) ) : '' ;
		$madingguru['_tgl']      = isset($_POST['_tgl']) ? sanitize_text_field(wp_unslash( $_POST['_tgl'] ) ) : '' ;
		$madingguru['_rel']      = isset($_POST['_rel']) ? sanitize_text_field(wp_unslash( $_POST['_rel'] ) ) : '' ;
		$madingguru['_add']      = isset($_POST['_add']) ? sanitize_text_field(wp_unslash( $_POST['_add'] ) ) : '' ;
		$madingguru['_telp']     = isset($_POST['_telp']) ? sanitize_text_field(wp_unslash( $_POST['_telp'] ) ) : '' ;
		$madingguru['_waguru']   = isset($_POST['_waguru']) ? sanitize_text_field(wp_unslash( $_POST['_waguru'] ) ) : '' ;
		$madingguru['_mail']     = isset($_POST['_mail']) ? sanitize_text_field(wp_unslash( $_POST['_mail'] ) ) : '' ;
		$madingguru['_madingfb'] = isset($_POST['_madingfb']) ? sanitize_text_field(wp_unslash( $_POST['_madingfb'] ) ) : '' ;
		$madingguru['_madingtw'] = isset($_POST['_madingtw']) ? sanitize_text_field(wp_unslash( $_POST['_madingtw'] ) ) : '' ;
		$madingguru['_madingig'] = isset($_POST['_madingig']) ? sanitize_text_field(wp_unslash( $_POST['_madingig'] ) ) : '' ;
		
	    foreach ($madingguru as $key => $value) {        
		    if( $post->post_type == 'revision' ) return; 
	        $value = implode(',', (array)$value); 
	        if(get_post_meta($post_id, $key, FALSE)) { 
	            update_post_meta($post_id, $key, $value);
	        } else { 
	            add_post_meta($post_id, $key, $value);
	        }
	        if(!$value) delete_post_meta($post_id, $key); // 
	    }

	}

	add_action('save_post', 'guru_data_meta', 1, 2); 
	
	// Start Education
	
	add_action('admin_init', 'guru_education', 1);
	function guru_education() {
    	add_meta_box( 'education', __('Educational History', 'sekolahpro'), 'edu_input', 'ustadz', 'normal', 'default');
    }

	function edu_input($post) {
    	global $post;
    	$edu_guru = get_post_meta($post->ID, 'edu_guru', true);
    	wp_nonce_field( 'edu_gurumeta', 'edu_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-edu' ).on('click', function() {
			var row = $( '.emptyedu.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyedu screen-reader-text' );
			row.insertBefore( '#edulisting tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-edu' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
        
		<div class="mading_metabox">
        	<table id="edulisting">
		    
		    	<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo esc_html_e( 'Education', 'sekolahpro' ); ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo esc_html_e( 'Year', 'sekolahpro' ); ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $edu_guru ) :
			foreach ( $edu_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduname[]" value="<?php if($field['eduname'] != '') echo esc_attr( $field['eduname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="eduyear[]" value="<?php if ($field['eduyear'] != '') echo esc_attr( $field['eduyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyedu screen-reader-text">
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="eduname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="eduyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-edu button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
		    </table>
		</div>
		
		<div class="mading_metabox"><a id="add-edu" class="button button-primary button-large" href="#"><?php echo esc_html_e( 'Add New', 'sekolahpro' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'edu_metasave');

	function edu_metasave($post_id) {
    	if ( ! isset( $_POST['edu_gurumeta'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['edu_gurumeta'] ) ), 'edu_gurumeta' ) )
	    	return;
	    
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'edu_guru', true);
    	$news = array();
	
    	$edunames = isset($_POST['eduname']) ? $_POST['eduname'] : array();
    	$eduyears = isset($_POST['eduyear']) ? $_POST['eduyear'] : array();
	
    	$counts = count( $edunames );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $edunames[$i] != '' ) {
	    		$news[$i]['eduname'] = wp_kses($edunames[$i], array());
				$news[$i]['eduyear'] = wp_kses($eduyears[$i], array());
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'edu_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'edu_guru', $olds );
	}	
    
	// End Education
	
	// Start Work History
	
	add_action('admin_init', 'guru_history', 1);
	
	function guru_history() {
    	add_meta_box( 'historial', __('Employment History', 'sekolahpro'), 'his_input', 'ustadz', 'normal', 'default');
    }

	function his_input($post) {
    	global $post;
    	$his_guru = get_post_meta($post->ID, 'his_guru', true);
    	wp_nonce_field( 'his_gurumeta', 'his_gurumeta' );
    	?>
    
    	<script type="text/javascript">
     	jQuery(document).ready(function( $ ){
    		$( '#add-his' ).on('click', function() {
			var row = $( '.emptyhis.screen-reader-text' ).clone(true);
			row.removeClass( 'emptyhis screen-reader-text' );
			row.insertBefore( '#hislisting tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-his' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
    	});
    	</script>
  
    	<div class="mading_metabox">
    		<table id="hislisting">
		    
		    	<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
				                	<?php echo esc_html_e( 'Work', 'sekolahpro' ); ?>
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<?php echo esc_html_e( 'Year', 'sekolahpro' ); ?>
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
					        	</div>
							</div>
						</div>
					</td>
				</tr>
			
         	<?php if ( $his_guru ) :
			foreach ( $his_guru as $field ) { ?>
             	<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisname[]" value="<?php if($field['hisname'] != '') echo esc_attr( $field['hisname'] ); ?>" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
				                	<input type="text" placeholder="" class="widefat" name="hisyear[]" value="<?php if ($field['hisyear'] != '') echo esc_attr( $field['hisyear'] ); ?>" />
								</div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php } else : ?>
			
	    		<tr>
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
				
			<?php endif; ?>
	
            	<!-- empty hidden one for jQuery -->
            	<tr class="emptyhis screen-reader-text">
            		<td>
					    <div class="madclear">
						    <div class="half">
							    <div class="halfin">
			    	            	<input type="text" class="widefat" name="hisname[]" />
								</div>
							</div>
							<div class="half">
							    <div class="halfin">
						        	<input type="text" class="widefat" name="hisyear[]" />
							    </div>
							</div>
							<div class="halfclose">
							    <div class="halfin">
							    	<a class="button remove-his button-primary" href="#"><?php echo esc_html_e( 'Remove', 'sekolahpro' ); ?></a>
					        	</div>
							</div>
						</div>
					</td>
				</tr>
	    	</table>
		</div>
		
		<div class="mading_metabox"><a id="add-his" class="button button-primary button-large" href="#"><?php echo esc_html_e( 'Add New', 'sekolahpro' ); ?></a></div> 
			
	<?php
    }

	add_action('save_post', 'his_metasave');

	function his_metasave($post_id) {
    	if ( ! isset( $_POST['his_gurumeta'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['his_gurumeta'] ) ), 'his_gurumeta' ) )
	    	return;
	
    	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
	    	return;
	
    	if (!current_user_can('edit_post', $post_id))
	    	return;
	
    	$olds = get_post_meta($post_id, 'his_guru', true);
    	$news = array();
	
    	$hisnames = isset($_POST['hisname']) ? $_POST['hisname'] : array();
    	$hisyears = isset($_POST['hisyear']) ? $_POST['hisyear'] : array();
	
    	$counts = count( $hisnames );
	
    	for ( $i = 0; $i < $counts; $i++ ) {
	    	if ( $hisnames[$i] != '' ) {
	    		$news[$i]['hisname'] = wp_kses($hisnames[$i], array());
				$news[$i]['hisyear'] = wp_kses($hisyears[$i], array());
	    	}
    	}
		
    	if ( !empty( $news ) && $news != $olds )
    		update_post_meta( $post_id, 'his_guru', $news );
    	elseif ( empty($news) && $olds )
    		delete_post_meta( $post_id, 'his_guru', $olds );
	}	
    
	// End Work History