<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_FourBlock_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingfourblock';
	}

	public function get_title() {
		return esc_html__( 'MAD : 4 Block', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'post', 'block' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<div class="four_block_post">
	    	<div class="ext_container madclear">
		        	<div class="madclear">
			        	<?php
				        	call_pengumuman_post();
					    	call_blog_post();
					    	call_fasilitas_post();
					    	call_ekskul_post();
				    	?>
					</div>
			</div>
	    </div>
		
		<?php
	}

}

