<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Newsticker_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingnewsticker';
	}

	public function get_title() {
		return esc_html__( 'MAD : Sekilas Info', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-form-vertical';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
	    	<div class="site_content madclear">
			    <div class="mad_ticker">
				    <div class="ext__container">
				        <div class="sekilas">
				    	    <span class="re_info"><?php echo __('Sekilas Info', 'mading'); ?></span>
				    	</div>
				        <div class="mad_today">
					        <?php 
							     $offset = get_option( 'gmt_offset' );
							     $ciusstime = strtotime(gmdate('Y-m-d H:i:s', strtotime('+'.$offset.' hours'))); 
							?>
					        <span><?php echo esc_html(wp_date('l, d M Y', strtotime($ciusstime))); ?></span>
				    	</div>
						<div class="runscroll">
					    	<div class="scroll text4">
						    	<ul class="scrollin my-news-ticker">
							    	<?php running_text_mading(); ?>
								</ul>
								<ul class="scrollin my-news-ticker">
							    	<?php running_text_mading(); ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php
	}

}

