<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Mading_Quotes_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'madingquotes';
	}

	public function get_title() {
		return esc_html__( 'MAD : Mading Quotes', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-blockquote';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-original' ];
	}

	public function get_keywords() {
		return [ 'image', 'post' ];
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		<div class="mading_quotes madclear">
	        <?php mading_slide_quotes(); ?>
    	</div>
		
		<?php
	}

}

