<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_FullEvent1_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'fullevent1';
	}

	public function get_title() {
		return esc_html__( 'MAD : Event Block 1', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'block_image',
			[
				'label' => esc_html__( 'Background Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/agenda.jpg',
				],
			]
		);
		$this->add_control(
			'block_parallax',
			[
				'label' => esc_html__( 'Background Parallax', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'scrolls',
				'options' => [
					'scrolls' => esc_html__( 'Deactivate', 'sekolahpro' ),
					'fixed' => esc_html__( 'Activate', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Overlay Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .event-full-block-1:before' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'block_opacity',
			[
				'label' => esc_html__( 'Opacity', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 0.8,
				],
				'selectors' => [
					'{{WRAPPER}} .event-full-block-1:before' => 'opacity: {{SIZE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .event-full-block-1' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .event-full-block-1' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_html__( 'Heading Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'heading_top',
			[
				'label' => esc_html__( 'Heading Top', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'agenda sekolah', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'tag_top',
			[
				'label' => esc_html__( 'Heading Top Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'htop_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev1-topheading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 28,
						],
					],
				],
			]
		);
		$this->add_control(
			'htop_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FF057C',
				'selectors' => [
					'{{WRAPPER}} .ev1-topheading' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'heading_bot',
			[
				'label' => esc_html__( 'Heading Bottom', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Latest Update', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'tag_bot',
			[
				'label' => esc_html__( 'Heading Bottom Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'hbot_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev1-botheading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Montserrat',
					],
					'font_weight' => [
				    	'default' => 800,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 55,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 55,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 45,
						],
					],
				],
			]
		);
		$this->add_control(
			'hbot_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .ev1-botheading' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_responsive_control(
			'hbot_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .ev1-botheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Image Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .ev1-img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .ev1-img:before' => 'padding-bottom: calc( {{SIZE}}{{UNIT}} - 30px );',
				],
			]
		);
		$this->add_control(
			'over_gb',
			[
				'label' => esc_html__( 'Overlay Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#888888',
				'selectors' => [
					'{{WRAPPER}} .ev1-inner a.ev1-img:before' => 'background: linear-gradient(rgba(0,0,0,0), {{VALUE}});',
				],
			]
		);
		$this->add_control(
			'over_color',
			[
				'label' => esc_html__( 'Overlay Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#444444',
				'selectors' => [
					'{{WRAPPER}} .ev1-clock' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev1-clock',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 40,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 40,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 30,
						],
					],
				],
			]
		);
		
		$this->add_control(
			'day_align',
			[
				'label' => esc_html__( 'Day Count Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'dayleft' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'daycenter' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'dayright' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'dayright',
				'toggle' => true,
			]
		);
		
		$this->add_control(
			'day_bg',
			[
				'label' => esc_html__( 'Day Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev1-hari' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'day_color',
			[
				'label' => esc_html__( 'Day Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev1-hari' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'day_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev1-hari',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 34,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 34,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 28,
						],
					],
				],
			]
		);
		$this->add_responsive_control(
			'date_border',
			[
				'label' => esc_html__( 'Date Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .ev1-hari' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'title_section',
			[
				'label' => esc_html__( 'Title Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .ev1-content' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'title_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .ev1-content' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev1-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 25,
						],
					],
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev1-title ' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'title_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .ev1-title' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_style',
			[
				'label' => esc_html__( 'Button Style', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ev1-bt1',
				'options' => [
					'ev1-bt1' => esc_html__( 'Style 1', 'sekolahpro' ),
					'ev1-bt2' => esc_html__( 'Style 2', 'sekolahpro' ),
					'ev1-bt3' => esc_html__( 'Style 3', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'button_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .ev1-chat' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_typo',
			[
				'label' => esc_html__( 'Typography', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::FONT,
				'default' => "Poppins",
				'selectors' => [
					'{{WRAPPER}} .ev1-chat' => 'font-family: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Arrow Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .ev1-chat' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'buttonacc_color',
			[
				'label' => esc_html__( 'Accent Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev1-chat:after' => 'border-right: 24px solid {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		$tophead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		$bothead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		?>
		    <div class="event-full-block-1 <?php echo $settings['block_parallax']; ?>" <?php if ( ! empty( $settings['block_image']['url'] ) ) { echo 'style="background-image: url( ' . $settings['block_image']['url'] . ' );"'; } ?>>
			    <?php // query
					$offset = get_option( 'gmt_offset' );
			        $today = strtotime(gmdate('Y-m-d H:i:s', strtotime('+'.$offset.' hours')));
	                query_posts( array( 
	                    'post_type' => 'agenda', 
						'ignore_sticky_posts' => 1,
				    	'meta_key' => '_minus',
				    	'posts_per_page' => 20,
			    		'meta_query' => array(
				             array(
					             'key' => '_minus',
				                 'value' => $today,
				                 'compare' => '>='
				             )
			             ),
			            'orderby' => 'meta_value',
			            'order' => 'ASC'
			            ) 
	            	);
					
					echo '<'. $tophead[ $settings['tag_top'] ] .' class="ev1-topheading">'. $settings['heading_top'] .'</'. $tophead[ $settings['tag_top'] ] .'>';
					echo '<'. $bothead[ $settings['tag_bot'] ] .' class="ev1-botheading">'. $settings['heading_bot'] .'</'. $bothead[ $settings['tag_bot'] ] .'>';
						
					$ev1count = 0;
					if (have_posts()) {
						echo '<div class="ev1-block">';
						echo '<div class="event1 owl-carousel owl-theme">';
				        while (have_posts()): the_post(); 
						global $post;
						$minus   = strtotime(get_post_meta($post->ID, '_tevent', true));
						$tevent  = get_post_meta($post->ID, '_tevent', true);
						$jam     = get_post_meta($post->ID, '_jam', true);
						$contwa  = get_post_meta($post->ID, '_contwa', true);
						
						$pack24  = gmdate( "H:i:s", strtotime( $jam ) );		
					    $sisa    = $minus-$today;
                        $end     = $tevent . ' ' . $pack24;	
						
						$ev1count++;
						
						if ( $sisa > 0 ) { 
						    ?>
					        <div class="item ev1-loop">
							    <div class="ev1-inner">
								    <?php if (has_post_thumbnail()) { ?>
			    			        	<a class="ev1-img" href="<?php the_permalink() ?>">
				    				    	<?php the_post_thumbnail('news'); ?>
				    			    	</a>
				    		    	<?php } else { ?>
					     		    	<a class="ev1-img" href="<?php the_permalink() ?>">
											<?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			            		    	</a>
					    	    	<?php } ?>
								    <div id="ev1clock<?php echo esc_html( $ev1count ).''. esc_html( $unic ); ?>" class="ev1-loopclock">
							            <div class="ev1-timer <?php echo $settings['day_align']; ?>">		    
						    		     	<span class="ev1-hari ev1-day">
									         	<span class="day1"></span><span class="day1text"><?php echo esc_html_e( 'Hari', 'mading' ); ?></span>
									     	</span>
									    	<span class="ev1-clock">
									        	<span class="jam1"></span>:<span class="min1"></span>:<span class="sec1"></span>
									    	</span>
										</div>
                                    </div>
									<div class="ev1-content">
							            <h3 class="ev1-title"><?php the_title(); ?></h3>
									    <div class="madclear">
								        	<a class="ev1-chat <?php echo $settings['button_style']; ?>" href="<?php the_permalink(); ?>"><i class="icon-mad-calendar"></i> Info Agenda</a>
								    	</div>
								    	
							        </div>
						    	</div>
							
								<script>
						    	function getTimeRemaining1(endtime){
									var t = Date.parse(endtime) - Date.parse(new Date());
									var sec1 = Math.floor( (t/1000) % 60 );
									var min1 = Math.floor( (t/1000/60) % 60 );
									var jam1 = Math.floor( (t/(1000*60*60)) % 24 );
									var day1 = Math.floor( t/(1000*60*60*24) );
									return {
										'total': t,
										'day1': day1,
										'jam1': jam1,
										'min1': min1,
										'sec1': sec1
									};
								}
								function initializeClock1(id, endtime){
									var clock = document.getElementById(id);
									var day1Span = clock.querySelector('.day1');
									var jam1Span = clock.querySelector('.jam1');
									var min1Span = clock.querySelector('.min1');
									var sec1Span = clock.querySelector('.sec1');
									
									function updateClock1(){
										var t = getTimeRemaining1(endtime);
										day1Span.innerHTML = t.day1;
										jam1Span.innerHTML = ('0' + t.jam1).slice(-2);
										min1Span.innerHTML = ('0' + t.min1).slice(-2);
										sec1Span.innerHTML = ('0' + t.sec1).slice(-2);
										if(t.total<=0){
											clearInterval(timeinterval);
										}
									}
									
									updateClock1();
									var timeinterval = setInterval(updateClock1,1000);
								}
								var deadline1 = '<?php echo gmdate( "F j Y H:i:s", strtotime( $end ) ); ?> UTC+0<?php echo esc_html( $offset ); ?>00';
								initializeClock1('ev1clock<?php echo esc_html( $ev1count ) .''. esc_html( $unic ); ?>', deadline1);
						    	</script>
					    	</div>
							
							
							<?php 
						}
						endwhile;
						echo '</div>';
						echo '</div>';
					} else {
						
					}
					
			    	wp_reset_query(); 
			    ?>
			</div>
			<script>
            jQuery(document).ready(function($) {
                var owl = $('.event1');
                owl.owlCarousel({
                    loop: true,
                    nav: true,
					navText: ["<span class='ev_arr'></span>","<i class='ev_arr'></span>"],
					dots: false,
                    lazyLoad: true,
			    	autoplay: false,
					animateOut: 'fadeOut',
			    	animateIn: 'fadeIn',
                    autoplayTimeout: 5000,
                    smartSpeed: 500,
                    autoplayHoverPause: true,
					autoHeight:true,
                    margin: 30,
			    	responsive:{
                        0:{ 
				    	    items:1
                        },
                        640:{
                            items:2
                        },
                        982:{
                            items:3
                        }
                    }    
                });
            });
            </script>
		<?php
	}

}