<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_FullEvent2_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'fullevent2';
	}

	public function get_title() {
		return esc_html__( 'MAD : Event Block 2', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'ev2_width',
			[
				'label'  => esc_html__( 'Max Width', 'sekolahpro' ),
				'type'   => \Elementor\Controls_Manager::SLIDER,
				'range'  => [
					'px' => [
						'min' => 320,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 800,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 800,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-title' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'block_image',
			[
				'label' => esc_html__( 'Background Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/agenda.jpg',
				],
			]
		);
		$this->add_control(
			'block_parallax',
			[
				'label' => esc_html__( 'Background Parallax', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'scrolls',
				'options' => [
					'scrolls' => esc_html__( 'Deactivate', 'sekolahpro' ),
					'fixed' => esc_html__( 'Activate', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Overlay Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .event-full-block-2:before' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'block_opacity',
			[
				'label' => esc_html__( 'Opacity', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 0.8,
				],
				'selectors' => [
					'{{WRAPPER}} .event-full-block-2:before' => 'opacity: {{SIZE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-loop' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-loop' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .event-full-block-2:after' => 'height: calc( {{SIZE}}{{UNIT}} + 40px );',
					'.is_small {{WRAPPER}} .event-full-block-2:after' => 'height: calc( {{SIZE}}{{UNIT}} + 20px );',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Title Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_accent',
			[
				'label' => esc_html__( 'Title Accent', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ev2-title1',
				'options' => [
					'ev2-title1' => esc_html__( 'Style 1', 'sekolahpro' ),
					'ev2-title2' => esc_html__( 'Style 2', 'sekolahpro' ),
					'ev2-title3' => esc_html__( 'Style 3', 'sekolahpro' ),
					'none'   => esc_html__( 'Normal', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'title_404',
			[
				'label' => esc_html__( 'No Agenda Title', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'No Agenda coming soon', 'sekolahpro' ),
				'description' => esc_html__( 'Add additional text to show if there is no Agenda', 'sekolahpro' ),
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3b1d82',
				'selectors' => [
					'{{WRAPPER}} .ev2-title' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'first_color',
			[
				'label' => esc_html__( 'Title First Line Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev2-title:first-line' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev2-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Montserrat',
					],
					'font_weight' => [
				    	'default' => 800,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 60,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 30,
						],
					],
				],
			]
		);
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-title' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'titleacc_color',
			[
				'label' => esc_html__( 'Accent Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev2-title1:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-title2:before' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .ev2-title2:after' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .ev2-title3:before' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .ev2-title3:after' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'title_botgap',
			[
				'label' => esc_html__( 'Title Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_accent',
			[
				'label' => esc_html__( 'Button Accent', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ev2-button2',
				'options' => [
					'ev2-button1' => esc_html__( 'Style 1', 'sekolahpro' ),
					'ev2-button2' => esc_html__( 'Style 2', 'sekolahpro' ),
					'ev2-button3' => esc_html__( 'Style 3', 'sekolahpro' ),
				],
			]
		);
		$this->add_responsive_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-button a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev2-button',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 500,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'button_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3b1d82',
				'selectors' => [
					'{{WRAPPER}} .ev2-button1 a.ev2-more' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button2 a.ev2-more' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button2 a.ev2-chat' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a.ev2-more' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a.ev2-chat' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a' => 'border-top: 4px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Text Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev2-button1 a.ev2-more' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button2 a.ev2-more' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button2 a.ev2-chat' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a.ev2-more' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a.ev2-chat' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'buttonacc1_color',
			[
				'label' => esc_html__( 'Accent 1', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev2-button1 a.ev2-chat' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button2 i' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 i' => 'background: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 a' => 'border-bottom: 4px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'buttonacc2_color',
			[
				'label' => esc_html__( 'Accent 2 (Except Style 1)', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev2-button2 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ev2-button3 i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'button_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-button' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'count_section',
			[
				'label' => esc_html__( 'Countdown Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'count_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 80,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .ev2-timer' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'count_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev2-timer' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'count_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ev2-timer',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'count_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .ev2-timer' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'countacc_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3b1d82',
				'selectors' => [
					'{{WRAPPER}} .jam, {{WRAPPER}} .min, {{WRAPPER}} .sec' => 'color: {{VALUE}};'
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'slide_section',
			[
				'label' => esc_html__( 'Slide Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'blockacc_bg',
			[
				'label' => esc_html__( 'Accent Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ev2-loopclock:after, {{WRAPPER}} .ev2-loopclock:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .event-full-block-2:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Arrow Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#3b1d82',
				'selectors' => [
					'{{WRAPPER}} .left_arr, {{WRAPPER}} .right_arr' => 'border: 1px solid {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'arrowacc_color',
			[
				'label' => esc_html__( 'Arrow Accent Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff057c',
				'selectors' => [
					'{{WRAPPER}} .left_arr:before, {{WRAPPER}} .right_arr:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .left_arr:after' => 'border-right: 8px solid {{VALUE}};',
					'{{WRAPPER}} .right_arr:after' => 'border-left: 8px solid {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		?>
		    <div class="event-full-block-2 luv-clear <?php echo $settings['block_parallax']; ?>" <?php if ( ! empty( $settings['block_image']['url'] ) ) { echo 'style="background-image: url( ' . $settings['block_image']['url'] . ' );"'; } ?>>
			    <?php // query
					$offset      = get_option( 'gmt_offset' );
					if ( $offset == 7 ) {
						$localtime = 'UTC+0700';
					} elseif ( $offset == 8 ) {
						$localtime = 'UTC+0800';
					} elseif ( $offset == 9 ) {
						$localtime ='UTC+0900';
					} else {
						$localtime = 'UTC+0700';
					}
    				$today = current_time('timestamp');
	                query_posts( array( 
	                    'post_type' => 'agenda', 
						'ignore_sticky_posts' => 1,
				    	'meta_key' => '_minus',
				    	'posts_per_page' => 20,
			    		'meta_query' => array(
				             array(
					             'key' => '_minus',
				                 'value' => $today,
				                 'compare' => '>='
				             )
			             ),
			            'orderby' => 'meta_value',
			            'order' => 'ASC'
			            ) 
	            	);
					
					$ev2count = 0;
					if (have_posts()) {
						echo '<div class="event2 owl-carousel owl-theme">';
				        while (have_posts()): the_post(); 
						global $post;
						$minus   = strtotime(get_post_meta($post->ID, '_tevent', true));
						$tevent  = get_post_meta($post->ID, '_tevent', true);
						$jam     = get_post_meta($post->ID, '_jam', true);
						$contwa  = get_post_meta($post->ID, '_contwa', true);
									
						$pack24  = date( "H:i:s", strtotime( $jam ) );		
						$sisa    = $minus-$today;
    					$end     = $tevent . ' ' . $pack24;	
						
						$ev2count++;
						
						if ( $sisa > 0 ) { 
						    ?>
					        <div class="item ev2-loop">
							    <div class="ev2-full">
							        <h3 class="ev2-title <?php echo $settings['title_accent']; ?>"><?php the_title(); ?></h3>
									<div class="ev2-button <?php echo $settings['button_accent']; ?> madclear">
								    	<a class="ev2-more" href="<?php the_permalink(); ?>"><i class="icon-mad-calendar"></i>Lihat<span> Agenda</span></a>
										<a class="ev2-chat" href="<?php the_permalink(); ?>"><i class="icon-mad-whatsapp"></i>Info<span> Agenda</span></a>
									</div>
							        <div id="ev2clock<?php echo esc_html( $ev2count ).''. esc_html( $unic ); ?>" class="ev2-loopclock">
							            <div class="ev2-timer">		    
						    		     	<span>
									         	<span class="hari"></span><span><?php echo esc_html_e( 'Hari', 'mading' ); ?></span>
									     	</span>
									    	<span>
									        	<span class="jam"></span>:<span class="min"></span>:<span class="sec"></span>
									    	</span>
										</div>
                                    </div>
						    	</div>
							
								<script>
						    	function getTimeRemaining(endtime){
									var t = Date.parse(endtime) - Date.parse(new Date());
									var sec = Math.floor( (t/1000) % 60 );
									var min = Math.floor( (t/1000/60) % 60 );
									var jam = Math.floor( (t/(1000*60*60)) % 24 );
									var hari = Math.floor( t/(1000*60*60*24) );
									return {
										'total': t,
										'hari': hari,
										'jam': jam,
										'min': min,
										'sec': sec
									};
								}
								function initializeClock(id, endtime){
									var clock = document.getElementById(id);
									var hariSpan = clock.querySelector('.hari');
									var jamSpan = clock.querySelector('.jam');
									var minSpan = clock.querySelector('.min');
									var secSpan = clock.querySelector('.sec');
									
									function updateClock(){
										var t = getTimeRemaining(endtime);
										hariSpan.innerHTML = t.hari;
										jamSpan.innerHTML = ('0' + t.jam).slice(-2);
										minSpan.innerHTML = ('0' + t.min).slice(-2);
										secSpan.innerHTML = ('0' + t.sec).slice(-2);
										if(t.total<=0){
											clearInterval(timeinterval);
										}
									}
									
									updateClock();
									var timeinterval = setInterval(updateClock,1000);
								}
								var deadline = '<?php echo gmdate( "F j Y H:i:s", strtotime( $end ) ); ?> <?php echo esc_html( $localtime ); ?>';
								initializeClock('ev2clock<?php echo esc_html( $ev2count ) .''. esc_html( $unic ); ?>', deadline);
							</script>
					    	</div>
							
							
							<?php 
							}
							
							if ( $ev2count == 5 ) {
								break;
							}
							
						endwhile;
						echo '</div>';
						?>
						
						<script>
            jQuery(document).ready(function($) {
                var owl = $('.event2');
                owl.owlCarousel({
                    loop: true,
                    nav: true,
					navText: ["<span class='left_arr'></span>","<i class='right_arr'></span>"],
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
					animateOut: 'fadeOut',
			    	animateIn: 'fadeIn',
                    autoplayTimeout: 5000,
                    smartSpeed: 500,
                    autoplayHoverPause: true,
					autoHeight:true,
                    margin: 0,
			    	items: 1,   
                });
            });
            </script>
						<?php
					} else {
						?>
					    	<div class="ev2-loop">
							    <div class="ev2-full">
							        <h3 class="ev2-title <?php echo $settings['title_accent']; ?>"><?php echo $settings['title_404']; ?></h3>
								</div>
							</div>
						<?php
					}
					
			    	wp_reset_query(); 
			    ?>
			</div>
		<?php
	}

}