<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_EditorialBlog_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'fulleditorblog';
	}

	public function get_title() {
		return esc_html__( 'MAD : Editorial & Blog', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .editorial_blog' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_blog' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_blog' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'blockacc1_bg',
			[
				'label' => esc_html__( 'Accent 1 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:before' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'blockacc1_top',
			[
				'label' => esc_html__( 'Top Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 30,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 30,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:before' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'blockacc1_left',
			[
				'label' => esc_html__( 'Left Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 70,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 70,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 70,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:before' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'blockacc2_bg',
			[
				'label' => esc_html__( 'Accent 1 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#008800',
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:after' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'blockacc2_top',
			[
				'label' => esc_html__( 'Top Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 5,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 5,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:after' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'blockacc2_left',
			[
				'label' => esc_html__( 'Left Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
						'step' => 5,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 110,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 110,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 110,
				],
				'selectors' => [
					'{{WRAPPER}} .editorial_mading:after' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_html__( 'Heading Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'eb_before',
			[
				'label' => esc_html__( 'Heading Top', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Editorial', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'eb_top',
			[
				'label' => esc_html__( 'Heading Top Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ebtop_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .eb_before',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
					],
				],
			]
		);
		$this->add_control(
			'htop_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FF057C',
				'selectors' => [
					'{{WRAPPER}} .eb_before' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'eb_after',
			[
				'label' => esc_html__( 'Heading Bottom', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( '& Blog Guru', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'eb_bot',
			[
				'label' => esc_html__( 'Heading Bottom Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ebbot_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .eb_after',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
					],
				],
			]
		);
		$this->add_control(
			'hbot_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .ev_after' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_responsive_control(
			'hbot_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .eb_after' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		
		
		$this->start_controls_section(
			'editorial_section',
			[
				'label' => esc_html__( 'Editorial Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'edtitle_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ed-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 28,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 28,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 22,
						],
					],
				],
			]
		);
		$this->add_control(
			'edtitle_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .ed-title a' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'edtitle_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ed-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 15,
					'left' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 15,
					'left' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 15,
					'left' => 50,
					'unit' => 'px',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'edcontent_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .ed-content',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.5,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'edcontent_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#555555',
				'selectors' => [
					'{{WRAPPER}} .ed-content' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'edcontent_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .ed-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 60,
					'left' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 60,
					'left' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 50,
					'bottom' => 60,
					'left' => 50,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'first_image',
			[
				'label' => esc_html__( 'Image 1', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/box.jpg',
				],
			]
		);
		$this->add_control(
			'second_image',
			[
				'label' => esc_html__( 'Image 2', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/box.jpg',
				],
			]
		);
		$this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .ed-img img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'second_bg',
			[
				'label' => esc_html__( 'Image 2 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .sec_image' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_padding',
			[
				'label' => esc_html__( 'Image 2 Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .sec_image' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_width',
			[
				'label' => esc_html__( 'Image 2 Width', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 60,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 60,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .sec_image' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_right',
			[
				'label' => esc_html__( 'Image 2 Right', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -80,
				],
				'selectors' => [
					'{{WRAPPER}} .sec_image' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_bottom',
			[
				'label' => esc_html__( 'Image 2 Bottom', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -60,
				],
				'selectors' => [
					'{{WRAPPER}} .sec_image' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'blog_section',
			[
				'label' => esc_html__( 'Blog Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'blog_bg',
			[
				'label' => esc_html__( 'Image 2 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .blog_mading' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'blog_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .blog_mading' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'blog_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .eb_inner' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'blog_style',
			[
				'label' => esc_html__( 'Thumbnail Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ebleft',
				'options' => [
					'ebleft' => esc_html__( 'Left', 'sekolahpro' ),
					'ebright' => esc_html__( 'Right', 'sekolahpro' ),
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ebdate_typo',
				'label' => esc_html__( 'Date Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .eb-date',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'ebdate_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#444444',
				'selectors' => [
					'{{WRAPPER}} .eb-date' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'ebauthor_color',
			[
				'label' => esc_html__( 'Author Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#444444',
				'selectors' => [
					'{{WRAPPER}} .eb-date span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ebtitle_typo',
				'label' => esc_html__( 'Title Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .eb-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.3,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 20,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 20,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'ebtitle_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .eb-title a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'thumb_radius',
			[
				'label' => esc_html__( 'Image Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .eb-img img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'blog_gap',
			[
				'label' => esc_html__( 'Loop Post Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 35,
				],
				'selectors' => [
					'{{WRAPPER}} .eb-loop' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'ebbutton_section',
			[
				'label' => esc_html__( 'Button Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'ebbutton_pos',
			[
				'label' => esc_html__( 'Button Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .eb-seeall' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ebbutton_typo',
				'label' => esc_html__( 'Button Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .eb-seeall a',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.3,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'ebbutton_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ff44aa',
				'selectors' => [
					'{{WRAPPER}} .eb-seeall a' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'ebbutton_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .eb-seeall a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'button_radius',
			[
				'label' => esc_html__( 'Button Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .eb-seeall a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		$tophead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		$bothead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		?>
		    <div class="editorial_blog">
			    <div class="eb_block madclear">
			    	<div class="editorial_mading">
					    <div class="ed_inner">
				    	<?php // query
					    	query_posts( array( 
						    	'post_type' => 'editorial', 
								'ignore_sticky_posts' => 1,
								'posts_per_page' => 1,
							));
							
							echo '<'. $tophead[ $settings['eb_top'] ] .' class="eb_before">'. $settings['eb_before'] .'</'. $tophead[ $settings['eb_top'] ] .'>';
					        echo '<'. $bothead[ $settings['eb_bot'] ] .' class="eb_after">'. $settings['eb_after'] .'</'. $bothead[ $settings['eb_bot'] ] .'>';
					
							if (have_posts()) {
								while (have_posts()): the_post(); 
								?>
								
								<div class="ed-loop">
								    <h3 class="ed-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									<div class="ed-content"><?php echo esc_html( smart_excerpt(get_the_excerpt(), 20) ); ?></div>
								    <div class="ed-img">
								    	<?php 
							            	if ( ! empty( $settings['first_image']['url'] ) ) {
									        	echo '<img src="' . $settings['first_image']['url'] . '" />';
									        	if ( ! empty( $settings['second_image']['url'] ) ) {
									            	echo '<img class="sec_image" src="' . $settings['second_image']['url'] . '" />';
								            	}
								        	}
							         	?>
									</div>
						    	</div>
								
								<?php 
								endwhile;
							}
							wp_reset_query(); 
						?>
					    </div>
					</div>
					<div class="blog_mading">
					    <div class="eb_inner <?php echo $settings['blog_style']; ?>">
				    	<?php // query
					    	query_posts( array( 
						    	'post_type' => 'blog', 
								'ignore_sticky_posts' => 1,
								'posts_per_page' => 4,
							));
							
							if (have_posts()) {
								while (have_posts()): the_post(); 
								?>
								
								<div class="eb-loop madclear">
								    <div class="eb-publish">
								    	<div class="eb-date"><?php echo 'Oleh : <span>'. ucfirst( get_the_author() ) .'</span>'; ?></div>
								        <h3 class="eb-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_date('d M Y'); ?> - <?php the_title(); ?></a></h3>
									</div>
								    <?php if (has_post_thumbnail()) { ?>
			    			        	<a class="eb-img" href="<?php the_permalink() ?>">
				    				    	<?php the_post_thumbnail('thumbnail'); ?>
				    			    	</a>
				    		    	<?php } else { ?>
					     		    	<a class="eb-img" href="<?php the_permalink() ?>">
											<?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'thumbnail' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			            		    	</a>
					    	    	<?php } ?>
						    	</div>
								
								<?php 
								endwhile;
							}
							wp_reset_query(); 
						?>
						<div class="eb-seeall madclear"><a href="<?php echo get_post_type_archive_link( 'blog' ); ?>">Lihat Semua</a></div>
					    </div>
					</div>
				</div>
			</div>
		<?php
	}

}