<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Guru_One_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'guruone';
	}

	public function get_title() {
		return esc_html__( 'MAD : Slide Guru 1 ', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'slide' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#8102CE',
				'selectors' => [
					'{{WRAPPER}} .guru_one_widget' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'block_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guru_one_widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'head_section',
			[
				'label' => esc_html__( 'Heading Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'head_title',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'description' => esc_html__( 'Use <span> and </span> tag to create different style', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'Get To Know Our Awesome <span>Teachers</span>', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'head_tag',
			[
				'label' => esc_html__( 'Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'DIV', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'head_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .guruone_heading' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'label' => esc_html__( 'Heading Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruone_heading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 600,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 45,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 45,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 36,
						],
					],
				],
			]
		);
		$this->add_control(
			'head_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guruone_heading' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'head_spancolor',
			[
				'label' => esc_html__( 'Span Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc00',
				'selectors' => [
					'{{WRAPPER}} .guruone_heading span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'head_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guruone_heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 20,
					'left' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 100,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 50,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'text_section',
			[
				'label' => esc_html__( 'Text Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subhead_text',
			[
				'label' => esc_html__( 'Additional Text', 'sekolahpro' ),
				'description' => esc_html__( 'Add additional text after Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'subhead_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .guruone_subheading' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subhead_typo',
				'label' => esc_html__( 'Heading Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruone_subheading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 22,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'subhead_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guruone_subheading' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'subhead_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guruone_subheading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 20,
					'right' => 100,
					'bottom' => 50,
					'left' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
        	'button_show',
			[
		     	'label' => esc_html__( 'Show Button', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'See All', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'See All', 'sekolahpro' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'button_link',
			[
				'label' => esc_html__( 'Link', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://ciuss.com', 'sekolahpro' ),
				'default' => [
			    	'url' => 'https://ciuss.com',
				],
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_font',
				'label' => esc_html__( 'Button Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .button_guru',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '700',
					],
					'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);$this->add_control(
			'morebg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc00',
				'selectors' => [
					'{{WRAPPER}} .button_guru a' => 'background: {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'morecolor',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#8102CE',
				'selectors' => [
					'{{WRAPPER}} .button_guru a' => 'color: {{VALUE}}; border: 2px solid {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'button_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .button_guru a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 100,
					'bottom' => 20,
					'left' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
					'unit' => 'px',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .button_guru a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 15,
					'right' => 30,
					'bottom' => 15,
					'left' => 30,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 15,
					'right' => 30,
					'bottom' => 15,
					'left' => 30,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 12,
					'right' => 24,
					'bottom' => 12,
					'left' => 24,
					'unit' => 'px',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .button_guru a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'slide_section',
			[
				'label' => esc_html__( 'Slide Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'guru_radius',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .guruone_start' => 'margin: calc( {{SIZE}}{{UNIT}}*2 ) {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'animatein',
			[
				'label' => esc_html__( 'Animate In', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeIn',
				'options' => [
					'fadeIn' => esc_html__( 'Fade In', 'sekolahpro' ),
					'slideInDown' => esc_html__( 'Slide In Down', 'sekolahpro' ),
					'slideInLeft' => esc_html__( 'Slide In Left', 'sekolahpro' ),
					'slideInRight' => esc_html__( 'Slide In Right', 'sekolahpro' ),
					'slideInUp' => esc_html__( 'Slide In Up', 'sekolahpro' ),
					'flipInX' => esc_html__( 'Flip In X', 'sekolahpro' ),
					'zoomIn' => esc_html__( 'Zoom In', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'animateout',
			[
				'label' => esc_html__( 'Animate Out', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeOut',
				'options' => [
					'fadeOut' => esc_html__( 'Fade Out', 'sekolahpro' ),
					'slideOutDown' => esc_html__( 'Slide Out Down', 'sekolahpro' ),
					'slideOutLeft' => esc_html__( 'Slide Out Left', 'sekolahpro' ),
					'slideOutRight' => esc_html__( 'Slide Out Right', 'sekolahpro' ),
					'slideOutUp' => esc_html__( 'Slide Out Up', 'sekolahpro' ),
					'flipOutX' => esc_html__( 'Flip Out X', 'sekolahpro' ),
					'zoomOut' => esc_html__( 'Zoom Out', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typo',
				'label' => esc_html__( 'Name Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruone_name',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '600',
					],
					'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 12,
						],
					],
				],
			]
		);
		$this->add_control(
			'name_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#8102CE',
				'selectors' => [
					'{{WRAPPER}} .guruone_name' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guruone_name a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .guruone_name' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'status_typo',
				'label' => esc_html__( 'Status Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruone_status',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '400',
					],
					'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 15,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 11,
						],
					],
				],
			]
		);
		$this->add_control(
			'status_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#5F9DF7',
				'selectors' => [
					'{{WRAPPER}} .guruone_status' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'status_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guruone_status' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'guru_gap',
			[
				'label' => esc_html__( 'Extra Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .space__guru' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'left_section',
			[
				'label' => esc_html__( 'Left Slide', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'first_leftbg',
			[
				'label' => esc_html__( 'Accent 1 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .guruone_slide:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'first_left',
			[
				'label' => esc_html__( 'Accent 1 Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ '%' ],
				'selectors' => [
					'{{WRAPPER}} .slideguru_effect .guruone_slide:after' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => -50,
					'left' => 0,
					'unit' => '%',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => -50,
					'left' => 0,
					'unit' => '%',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => -50,
					'left' => 0,
					'unit' => '%',
				],
			]
		);
		
		
		$this->add_control(
			'second_leftbg',
			[
				'label' => esc_html__( 'Accent 2 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#9700ff',
				'selectors' => [
					'{{WRAPPER}} .guruone_slide:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .guruone' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_left',
			[
				'label' => esc_html__( 'Accent 2 Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ '%' ],
				'selectors' => [
					'{{WRAPPER}} .slideguru_effect .guruone_slide:before' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => -85,
					'unit' => '%',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => -85,
					'unit' => '%',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => -85,
					'unit' => '%',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'right_section',
			[
				'label' => esc_html__( 'Right Slide', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'first_rightbg',
			[
				'label' => esc_html__( 'Accent 1 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#97ABFF',
				'selectors' => [
					'{{WRAPPER}} .gurutwo_slide:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'first_right',
			[
				'label' => esc_html__( 'Accent 1 Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ '%' ],
				'selectors' => [
					'{{WRAPPER}} .slideguru_effect .gurutwo_slide:after' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => -85,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => -85,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => -85,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
			]
		);
		
		$this->add_control(
			'second_rightbg',
			[
				'label' => esc_html__( 'Accent 2 Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .gurutwo_slide:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .gurutwo' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'second_right',
			[
				'label' => esc_html__( 'Accent 2 Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ '%' ],
				'selectors' => [
					'{{WRAPPER}} .slideguru_effect .gurutwo_slide:before' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => -50,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
				'tablet_default' => [
					'top' => -50,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
				'mobile_default' => [
					'top' => -50,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => '%',
				],
			]
		);
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$head_tag = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
		];
		?>
		<div class="guru_one_widget">
		    <div class="guru_one_inner madclear">
				<div class="guru_one_left">
					<<?php echo $head_tag[ $settings['head_tag'] ]; ?> class="guruone_heading"><?php echo $settings['head_title']; ?></<?php echo $head_tag[ $settings['head_tag'] ]; ?>>
					<div class="guruone_subheading"><?php echo $settings['subhead_text']; ?></div>
					<?php 
						            if ( 'yes' === $settings['button_show'] ) {
				        				if ( $settings['button_link']['url'] ) { 
				        				?>
										    <div class="button_guru">
							                	<a href="<?php echo $settings['button_link']['url']; ?>">
								                	<?php echo $settings['button_text']; ?>
								            	</a>
											</div>
							        	<?php
							            }
						        	}
					        	?>
				</div>
				<div class="guru_one_right">
				    <div class="madclear">
				    	<div class="guru_one_first_block">
						    <div class="guruone_start">
							<div class="guruone_slide">
							<?php 
						    	if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$args = array(
							    	'post_type' => $gurus,
									'posts_per_page' => 15,
									'orderby' => 'rand',
									'ignore_sticky_posts' => 1, 
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '='
										)
									)
								);
								query_posts($args);
							?>
							 	<div class="guruone owl-carousel owl-theme">
							    	<?php 
								    	if (have_posts()) {
											while (have_posts()): the_post();
											global $post;
											?>
											<div class="item item_guruone">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	echo '<img src="'. esc_url( get_theme_file_uri('images/guru.jpg') ).'" />';
												    	}
													?></a>
												</div>
												<div class="guruone_name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												<div class="guruone_status">
												    	<?php
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																foreach( $terms as $termjab ) {
																	$term_link = get_term_link( $termjab, 'jab');
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
															}
														?>
												</div>
											</div>
											<?php 
											endwhile;
										}
									?>
								</div>
							<?php wp_reset_query(); ?>
							</div>
							<div class="space__guru space__one">
							</div>
							</div>
						</div>
						<div class="guru_one_first_block">
						    <div class="guruone_start">
							<div class="space__guru space__two">
							</div>
							<div class="gurutwo_slide">
							<div class="gurutwo_accent"></div>
							<?php 
						    	if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$args = array(
							    	'post_type' => $gurus,
									'posts_per_page' => 15,
									'orderby' => 'rand',
									'ignore_sticky_posts' => 1, 
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '!='
										)
									)
								);
								query_posts($args);
							?>
							 	<div class="gurutwo owl-carousel owl-theme">
							    	<?php 
								    	if (have_posts()) {
											while (have_posts()): the_post();
											?>
											<div class="item item_guruone">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	echo '<img src="'. esc_url( get_theme_file_uri('images/guru.jpg') ).'" />';
												    	}
													?></a>
												</div>
												<div class="guruone_name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												<div class="guruone_status">
												    	<?php
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																foreach( $terms as $termjab ) {
																	$term_link = get_term_link( $termjab, 'jab');
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
															}
														?>
												</div>
											</div>
											<?php 
											endwhile;
										}
									?>
								</div>
							<?php wp_reset_query(); ?>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script>
            jQuery(document).ready(function($) {
                var owl = $('.guruone');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
					animateOut: '<?php echo $settings['animateout']; ?>',
			    	animateIn: '<?php echo $settings['animatein']; ?>',
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: false,
                    margin: 10,
			    	items: 1,   
                });
            });
			jQuery(document).ready(function($) {
                var owl = $('.gurutwo');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
					animateOut: '<?php echo $settings['animateout']; ?>',
			    	animateIn: '<?php echo $settings['animatein']; ?>',
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: false,
                    margin: 10,
			    	items: 1,   
                });
            });
			
			var distance = jQuery('.guru_one_widget').offset().top;
			jQuery(window).scroll(function() {
				if ( jQuery(this).scrollTop() > distance - 300 ) {
					jQuery('.guru_one_widget').addClass('slideguru_effect');
				} else {
					jQuery('.guru_one_widget').removeClass('slideguru_effect');
				}
			});
        </script>
		<?php
	}

	protected function content_template() {
		?>
		<#
		head_tag = {
			'h1': 'h1',
			'h2': 'h2',
			'h3': 'h3',
			'h4': 'h4',
			'h5': 'h5',
			'h6': 'h6',
		};
		#>
		<# var serviconHTML = elementor.helpers.renderIcon( view, settings.iconoverlay_icon, { 'aria-hidden': true }, 'i' , 'object' ); #>
		<div class="guru_one_widget madclear">
		    <div class="guru_one_inner">
		        <div class="guru_one_left">
					<{{{ head_tag[ settings.head_tag ] }}} class="guruone_heading">{{{ settings.head_title }}}</{{{ head_tag[ settings.head_tag ] }}}>
					<div class="guruone_subheading">{{{ settings.subhead_text }}}</div>
					<# if ( 'yes' === settings.button_show ) { #>
			                    	<# if ( settings.button_link.url ) { #>
									    <div class="button_guru">
				                            <a href="{{ settings.button_link.url }}">
										    	{{{ settings.button_text }}}
											</a>
										</div>
									<# } #>
								<# } #>
				</div>
				<div class="guru_one_right">
				    <div class="madclear">
				    	<div class="guru_one_first_block">
						    <div class="guruone_start">
							<div class="guruone_slide">
							<?php 
						    	if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$args = array(
							    	'post_type' => $gurus,
									'posts_per_page' => 15,
									'orderby' => 'rand',
									'ignore_sticky_posts' => 1, 
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '='
										)
									)
								);
								query_posts($args);
							?>
						     	<div class="guruone owl-carousel owl-theme">
							    	<?php 
								    	if (have_posts()) {
											while (have_posts()): the_post();
											global $post;
											?>
											<div class="item item_guruone">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	echo '<img src="'. esc_url( get_theme_file_uri('images/guru.jpg') ).'" />';
												    	}
													?></a>
												</div>
												<div class="guruone_name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												<div class="guruone_status">
												    	<?php
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																foreach( $terms as $termjab ) {
																	$term_link = get_term_link( $termjab, 'jab');
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
															}
														?>
												</div>
											</div>
											<?php 
											endwhile;
										}
									?>
								</div>
							<?php wp_reset_query(); ?>
							</div>
							<div class="space__guru space__one">
							</div>
							</div>
						</div>
						<div class="guru_one_first_block">
					    	<div class="guruone_start">
						    <div class="space__guru space__two">
							</div>
							<div class="gurutwo_slide">
							<div class="gurutwo_accent"></div>
							<?php 
						    	if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$args = array(
							    	'post_type' => $gurus,
									'posts_per_page' => 15,
									'orderby' => 'rand',
									'ignore_sticky_posts' => 1, 
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '!='
										)
									)
								);
								query_posts($args);
							?>
							 	<div class="gurutwo owl-carousel owl-theme">
							    	<?php 
								    	if (have_posts()) {
											while (have_posts()): the_post();
											?>
											<div class="item item_guruone">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	if ( get_theme_mod('madingphoto_image') != "" ) {
																$normalphoto = attachment_url_to_postid( get_theme_mod('madingphoto_image'));
																$showphoto = wp_get_attachment_image_url( $normalphoto, 'photo' );
																echo '<img src="'. esc_url( $showphoto ) .'"/>';
															} else {
																echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/guru.jpg"/>';
															}
												    	}
													?></a>
												</div>
												<div class="guruone_name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												<div class="guruone_status">
												    	<?php
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																foreach( $terms as $termjab ) {
																	$term_link = get_term_link( $termjab, 'jab');
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
															}
														?>
												</div>
											</div>
											<?php 
											endwhile;
										}
									?>
								</div>
							<?php wp_reset_query(); ?>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script>
            jQuery(document).ready(function($) {
                var owl = $('.guruone');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
			    	animateOut: '{{ settings.animateout }}',
			    	animateIn: '{{ settings.animatein }}',
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: false,
                    margin: 10,
			    	items: 1,   
                });
            });
			jQuery(document).ready(function($) {
                var owl = $('.gurutwo');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
			    	animateOut: '{{ settings.animateout }}',
			    	animateIn: '{{ settings.animatein }}',
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: false,
                    margin: 10,
			    	items: 1,   
                });
            });
			
			var distance = jQuery('.guru_one_widget').offset().top;
			jQuery(window).scroll(function() {
				if ( jQuery(this).scrollTop() > distance - 300   ) {
					jQuery('.guru_one_widget').addClass('slideguru_effect');
				} else {
					jQuery('.guru_one_widget').removeClass('slideguru_effect');
				}
			});
        </script>
		<?php
	}

}

