<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Guru_Three_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'guruthree';
	}

	public function get_title() {
		return esc_html__( 'MAD : Daftar Guru 3 ', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'slide' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'block_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
				],
			]
		);
		$this->add_control(
			'blocktop_bg',
			[
				'label' => esc_html__( 'Top Accent', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget:before' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'blocktop_height',
			[
				'label' => esc_html__( 'Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 500,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 300,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 250,
				],
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget:before' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'blockbot_bg',
			[
				'label' => esc_html__( 'Bottom Accent', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#eeeeee',
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget:after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'blockbot_height',
			[
				'label' => esc_html__( 'Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 900,
						'step' => 30,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 350,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 350,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 150,
				],
				'selectors' => [
					'{{WRAPPER}} .guru_three_widget:after' => 'width: {{SIZE}}{{UNIT}};',
					'.is_mobile {{WRAPPER}} .guru_three_widget:after' => 'height: {{SIZE}}{{UNIT}}; width: 100% !important;',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'head_section',
			[
				'label' => esc_html__( 'Heading Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'head_title',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'description' => esc_html__( 'Use <span> and </span> tag to create different style', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'The best <span>Teachers</span>', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'head_tag',
			[
				'label' => esc_html__( 'Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'DIV', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'head_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .guruthree_heading' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'label' => esc_html__( 'Heading Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruthree_heading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Chivo Mono',
					],
					'font_weight' => [
				    	'default' => 600,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 45,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 45,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 36,
						],
					],
				],
			]
		);
		$this->add_control(
			'head_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .guruthree_heading' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'head_spancolor',
			[
				'label' => esc_html__( 'Span Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#555555',
				'selectors' => [
					'{{WRAPPER}} .guruthree_heading span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'head_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guruthree_heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 100,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 50,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'text_section',
			[
				'label' => esc_html__( 'Text Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subhead_text',
			[
				'label' => esc_html__( 'Additional Text', 'sekolahpro' ),
				'description' => esc_html__( 'Add additional text after Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'subhead_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .guruthree_subheading' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subhead_typo',
				'label' => esc_html__( 'Heading Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruthree_subheading',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Inconsolata',
					],
					'font_weight' => [
				    	'default' => 500,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 20,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 20,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
			]
		);
		$this->add_control(
			'subhead_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#888888',
				'selectors' => [
					'{{WRAPPER}} .guruthree_subheading' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'headhead_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guruthree_subheading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 20,
					'right' => 100,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
        	'button_show',
			[
		     	'label' => esc_html__( 'Show Button', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);
		$this->add_control(
			'button_left',
			[
				'label' => esc_html__( 'Left Text', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Male', 'sekolahpro' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'buttonleft_link',
			[
				'label' => esc_html__( 'Link', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://ciuss.com', 'sekolahpro' ),
				'default' => [
			    	'url' => 'https://ciuss.com',
				],
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonleft_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .button_threeleft' => 'background: {{VALUE}};',
					'{{WRAPPER}} .button_threeright:hover' => 'background: {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonleft_bd',
			[
				'label' => esc_html__( 'Border', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .button_threeleft' => 'border: 2px solid {{VALUE}};',
					'{{WRAPPER}} .button_threeright:hover' => 'border: 2px solid {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonleft_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .button_threeleft' => 'color: {{VALUE}};',
					'{{WRAPPER}} .button_threeright:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'button_right',
			[
				'label' => esc_html__( 'Right Text', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Female', 'sekolahpro' ),
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonright_link',
			[
				'label' => esc_html__( 'Link', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://ciuss.com', 'sekolahpro' ),
				'default' => [
			    	'url' => 'https://ciuss.com',
				],
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonright_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .button_threeright' => 'background: {{VALUE}};',
					'{{WRAPPER}} .button_threeleft:hover' => 'background: {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonright_bd',
			[
				'label' => esc_html__( 'Border', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .button_threeright' => 'border: 2px solid {{VALUE}};',
					'{{WRAPPER}} .button_threeleft:hover' => 'border: 2px solid {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'buttonright_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .button_threeright' => 'color: {{VALUE}};',
					'{{WRAPPER}} .button_threeleft:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_font',
				'label' => esc_html__( 'Button Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .button_guruthree span',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '700',
					],
					'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
					],
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .button_guruthree span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 15,
					'right' => 30,
					'bottom' => 15,
					'left' => 30,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 15,
					'right' => 30,
					'bottom' => 15,
					'left' => 30,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 12,
					'right' => 24,
					'bottom' => 12,
					'left' => 24,
					'unit' => 'px',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 30,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .button_guruthree span' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
			    	'button_show' => 'yes',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'add_section',
			[
				'label' => esc_html__( 'Additional Text Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
        	'text_show',
			[
		     	'label' => esc_html__( 'Show Additional', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
			]
		);
		$this->add_control(
			'add_text',
			[
				'label' => esc_html__( 'Additional Text', 'sekolahpro' ),
				'description' => esc_html__( 'Add additional text after Button', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur', 'sekolahpro' ),
				'condition' => [
			    	'text_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'add_align',
			[
				'label' => esc_html__( 'Text Align', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .guruthree_adding' => 'text-align: {{VALUE}};',
				],
				'condition' => [
			    	'text_show' => 'yes',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'add_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruthree_adding',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Inconsolata',
					],
					'font_weight' => [
				    	'default' => 500,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.4,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
				'condition' => [
			    	'text_show' => 'yes',
				],
			]
		);
		$this->add_control(
			'add_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#888888',
				'selectors' => [
					'{{WRAPPER}} .guruthree_adding' => 'color: {{VALUE}};',
				],
				'condition' => [
			    	'text_show' => 'yes',
				],
			]
		);
		
		$this->add_responsive_control(
			'add_margin',
			[
				'label' => esc_html__( 'Margin', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .guruthree_adding' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 20,
					'right' => 100,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
				],
				'condition' => [
			    	'text_show' => 'yes',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'slide_section',
			[
				'label' => esc_html__( 'Slide Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'status_typo',
				'label' => esc_html__( 'Status Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruthree_jab, {{WRAPPER}} .guru_three_add',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '500',
					],
					'font_family' => [
				    	'default' => 'Inconsolata',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 14,
						],
					],
				],
			]
		);
		$this->add_control(
			'status_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .guruthree_jab' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typo',
				'label' => esc_html__( 'Name Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .guruthree_link a',
				'fields_options' => [
			    	'font_weight' => [
				    	'default' => '600',
					],
					'font_family' => [
				    	'default' => 'Chivo Mono',
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 18,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
					],
				],
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .guruthree_link a' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->end_controls_section();
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$head_tag = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
		];
		?>
		<div class="guru_three_widget">
		    <div class="guru_three_inner madclear">
				<div class="guru_three_left">
					<<?php echo $head_tag[ $settings['head_tag'] ]; ?> class="guruthree_heading"><?php echo $settings['head_title']; ?></<?php echo $head_tag[ $settings['head_tag'] ]; ?>>
					<div class="guruthree_subheading"><?php echo $settings['subhead_text']; ?></div>
					
					<?php 
						if ( 'yes' === $settings['button_show'] ) {
				        	
							    if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$guruwanita = array(
							    	'post_type' => $gurus,
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '='
										)
									)
								);
								$wanita = new WP_Query( $guruwanita );
								
								$gurulakilaki = array(
							    	'post_type' => $gurus,
									'meta_query' => array(
								    	array(
									    	'key' => '_sex',
											'value' => 'Perempuan',
											'compare' => '!='
										)
									)
								);
								$lakilaki = new WP_Query( $gurulakilaki );
								
				        		?>
								
								<div class="button_guruthree">
								    <?php 
								    	if ( $settings['buttonleft_link']['url'] ) { 
										?>
									    	<a href="<?php echo $settings['buttonleft_link']['url']; ?>">
										    	<span class="button_threeleft"><?php echo $lakilaki->post_count .' '. $settings['button_left']; ?></span>
											</a><?php
										}
										if ( $settings['buttonright_link']['url'] ) { 
										?><a href="<?php echo $settings['buttonright_link']['url']; ?>">
										    	<span class="button_threeright"><?php echo $wanita->post_count .' '. $settings['button_right']; ?></span>
											</a>
										<?php
										}
									?>
								</div>
								
							    <?php
							
						}
					?>
				    <div class="guruthree_adding"><?php echo $settings['add_text']; ?></div>
					
				</div>
				<div class="guru_three_right">
				    <div class="madclear">
				    	<div class="guru_three_block">
						    <div class="guruthree_start">
							<?php 
						    	if ( get_theme_mod('sekolah_type') == "akademi" ) {
									$gurus = 'dosen';
								} else if ( get_theme_mod('sekolah_type') == "pesantren" ) {
									$gurus = 'ustadz';
								} else {
									$gurus = 'gtk';
								}
								$args = array(
							    	'post_type' => $gurus,
									'posts_per_page' => 70,
									'orderby' => 'rand',
									'ignore_sticky_posts' => 1,
								);
								query_posts($args);
							?>
							 	<div class="guruthree owl-carousel owl-theme">
							    	<?php 
								    	if (have_posts()) {
											$number = 0;
											echo '<div class="item">';
											while (have_posts()): the_post();
											global $post;
											$mas = get_post_meta($post->ID, '_mas', true);
											$tangmas = wp_date("d F Y", strtotime($mas));
											$number++;
											if ( $number == 7 || $number == 14 || $number == 21 || $number == 28 || $number == 35 || $number == 42 || $number == 49 || $number == 56 || $number == 63 || $number == 70 ) {
											?>
											<div class="hexagon">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	echo '<img src="'. esc_url( get_theme_file_uri('images/guru.jpg') ).'" />';
												    	}
													?></a>
												</div>
												<div class="guru__detail">
												    <div class="guruthree_link"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												    <?php 
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																echo '<div class="guruthree_jab">';
																foreach( $terms as $termjab ) {
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
																echo '</div>';
															}
												    ?>
												</div>
											</div>
											</div>
											<div class="item">
											<?php 
											} else {
											?>
											<div class="hexagon">
										    	<div class="guru__photo">
											    	<a href="<?php the_permalink() ?>"><?php 
												    	if (has_post_thumbnail()) { 
												        	the_post_thumbnail('photo');
												    	} else {
													    	if ( get_theme_mod('madingphoto_image') != "" ) {
																$normalphoto = attachment_url_to_postid( get_theme_mod('madingphoto_image'));
																$showphoto = wp_get_attachment_image_url( $normalphoto, 'photo' );
																echo '<img src="'. esc_url( $showphoto ) .'"/>';
															} else {
																echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/guru.jpg"/>';
															}
												    	}
													?></a>
												</div>
												<div class="guru__detail">
												    <div class="guruthree_link"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></div>
												    <?php 
													    	$terms = get_the_terms( $post->ID , 'jab' );
															if ( $terms != null ){
																echo '<div class="guruthree_jab">';
																foreach( $terms as $termjab ) {
																	echo esc_html( $termjab->name );
																	unset($termjab);
																}
																echo '</div>';
															}
												    ?>
												</div>
											</div>
											<?php
											}
											endwhile;
											echo '</div>';
										}
									?>
								</div>
							<?php wp_reset_query(); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script>
            jQuery(document).ready(function($) {
                var owl = $('.guruthree');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
					animateOut: 'fadeOut',
			    	animateIn: 'fadeIn',
                    autoplayTimeout: 12000,
                    smartSpeed: 500,
                    autoplayHoverPause: true,
                    margin: 10,
			    	items: 1,   
                });
            });
			
			var distance = jQuery('.guru_one_widget').offset().top;
			jQuery(window).scroll(function() {
				if ( jQuery(this).scrollTop() > distance - 300 ) {
					jQuery('.guru_one_widget').addClass('slideguru_effect');
				} else {
					jQuery('.guru_one_widget').removeClass('slideguru_effect');
				}
			});
        </script>
		<?php
	}

}

