<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Header_Three_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'header-three';
	}

	public function get_title() {
		return esc_html__( 'MAD : Header 3', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-nav-menu';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'menu', 'navigation' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' => esc_html__( 'Header Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'fixed_enable',
			[
				'label' => esc_html__( 'Header Fixed', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Fixed', 'sekolahpro' ),
				'label_off' => esc_html__( 'Scroll', 'sekolahpro' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'full_enable',
			[
				'label' => esc_html__( 'Header Layout', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Boxed', 'sekolahpro' ),
				'label_off' => esc_html__( 'Full', 'sekolahpro' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'boxed_enable',
			[
				'label' => esc_html__( 'Width', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1100,
						'max' => 2000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1280,
				],
				'selectors' => [
					'{{WRAPPER}} .header__threewidth' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
			    	'full_enable' => 'yes',
				],
			]
		);
		$this->add_control(
			'headthree_background',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .header__three' => 'background: {{VALUE}};',	
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'logo_section',
			[
				'label' => esc_html__( 'Logo Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'logoimage',
			[
				'label' => esc_html__( 'Choose Logo', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => plugin_dir_url( __FILE__ ).'img/logo.png',
				],
			]
		);
		$this->add_responsive_control(
			'logoheight',
			[
				'label' => esc_html__( 'Logo Height', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 80,
						'step' => 2,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .logo__three' => 'height: {{SIZE}}{{UNIT}}; padding-top: calc( calc( calc( 80px - {{SIZE}}{{UNIT}} ) / 2 ) + 20px ); padding-bottom: calc( calc( calc( 80px - {{SIZE}}{{UNIT}} ) / 2 ) + 20px );',
					'{{WRAPPER}} .logo__three img' => 'height: {{SIZE}}{{UNIT}};',
					'.is_small {{WRAPPER}} .logo__three' => 'height: {{SIZE}}{{UNIT}}; padding-top: calc( calc( calc( 40px - {{SIZE}}{{UNIT}} ) / 2 ) + 10px ); padding-bottom: calc( calc( calc( 40px - {{SIZE}}{{UNIT}} ) / 2 ) + 10px );',
					
				],
			]
		);
		$this->add_control(
			'logothree_background',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .logo__three' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'call_area',
			[
				'label' => esc_html__( 'Contact Phone', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'phone_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .call__three' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'iconphone',
			[
				'label' => esc_html__( 'Choose Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-phone-alt',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'phone_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .call__three a',
			]
		);
		$this->add_control(
			'headphone',
			[
				'label' => esc_html__( 'Phone Number', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'placeholder' => esc_html__( '+62 8152 xxxx xxx', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'icon_bg',
			[
				'label' => esc_html__( 'Icon Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .call__three .fa, .call__three .fas, .call__three .far, .call__three .fab' => 'background: {{VALUE}};',
					'{{WRAPPER}} .call__three i' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#001188',
				'selectors' => [
					'{{WRAPPER}} .call__three i' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'phone_color',
			[
				'label' => esc_html__( 'Phone Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .call__three a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'menu_section',
			[
				'label' => esc_html__( 'Menu Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'menu__threebg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#dd3355',
				'selectors' => [
					'{{WRAPPER}} .mading__three' => 'background: {{VALUE}};',
					'{{WRAPPER}} .menu__three' => 'background: {{VALUE}};',
					'.is_mobile {{WRAPPER}} .three__menu .nav__menu' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'menumading',
			[
				'label' => esc_html__( 'Menu Mading', 'sekolahpro' ),
				'description' => esc_html__( 'Choose which menu you want to show.', 'sekolahpro' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options'     => get_wpsekolah_menu(),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'menuthree_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .header__three',
			]
		);
		$this->add_control(
			'menu__threecolor',
			[
				'label' => esc_html__( 'Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .mading__three li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .menu__three' => 'color: {{VALUE}};',
					'{{WRAPPER}} .three__icon:after' => 'border-top: 3px solid {{VALUE}}; border-bottom: 3px solid {{VALUE}};',
					'{{WRAPPER}} .three__icon:before' => ' border-bottom: 3px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'menu__threehover',
			[
				'label' => esc_html__( 'Menu Hover', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .mading__three li a:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__three li a span' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'span__threebg',
			[
				'label' => esc_html__( 'Span Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .mading__three li a span' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'span__threecolor',
			[
				'label' => esc_html__( 'Span Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__three li a span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'submenu__threebg',
			[
				'label' => esc_html__( 'Sub Menu Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .mading__three li ul li' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mading__three.desktop li ul:before' => 'border-bottom-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'submenu__threecolor',
			[
				'label' => esc_html__( 'Sub Menu Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .mading__three li ul li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__three li ul li:hover a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mading__three li ul li.menu-item-has-children:after' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'topheader_section',
			[
				'label' => esc_html__( 'Social Media', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'social_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .add__three' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'headaddress',
			[
				'label' => esc_html__( 'School Address', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Jln. Kenangan...', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'addthree_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .add__three',
			]
		);
		$this->add_control(
			'address_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .add__three' => 'color: {{VALUE}};',
				],
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'socialtext',
			[
				'label' => esc_html__( 'Social Name', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Facebook', 'sekolahpro' ),
				'placeholder' => esc_html__( 'Facebook', 'sekolahpro' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'socialicon',
			[
				'label' => esc_html__( 'Social Media Icon', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'fa-brands',
				],
			]
		);
		$repeater->add_control(
			'sociallink',
			[
				'label' => esc_html__( 'Link', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://ciuss.com', 'sekolahpro' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);

		/* End repeater */

		$this->add_control(
			'social_items',
			[
				'label' => esc_html__( 'Social Media', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),           /* Use our repeater */
				'default' => [
					[
						'socialtext' => esc_html__( 'Facebook', 'sekolahpro' ),
						'socialicon' => 'fab fa-facebook-f',
						'sociallink' => '',
					],
				],
				'title_field' => '{{{ socialtext }}}',
			]
		);
		$this->add_control(
			'medicon_bg',
			[
				'label' => esc_html__( 'Icon Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .icon_header i' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_right',
			[
				'label' => esc_html__( 'Icon Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .icon_header i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$menu = wp_nav_menu(
			array(
				'menu'            => $settings['menumading'],
				'menu_class'      => 'mading__three desktop', 
				'container_class' => 'nav__menu',
				'container'       => 'div',
				'menu_id'         => 'menuthree', 
				'echo'            => false,
				'fallback_cb'     => false
			)
		);
		if ( 'yes' === $settings['fixed_enable'] ) {
			echo '<div class="before__three__fixed"></div>';
			echo '<div class="header__three three__fixed">';
		} else {
			echo '<div class="header__three">';
		}
		?>
		
		    <div class="header__threewidth madclear">
	        	<div class="logo__three">
		        	<a href="<?php echo home_url(); ?>">
			          	<img src="<?php echo $settings['logoimage']['url'];?>" />
		    		</a>
		    	</div>
				<div class="call__three">
			    	<div class="three__number">
				    	<?php 
						    echo '<a target="_blank" href="tel:' . $settings['headphone'] . '">';
					    	\Elementor\Icons_Manager::render_icon( $settings['iconphone'], [ 'aria-hidden' => 'true' ] );
							echo '<span class="headphone">' . $settings['headphone'] . '</span>';
							echo '</a>';
						?>
					</div>
				</div>
				<div class="menu__three">
			    	<div class="three__menu madclear">
				    	<?php echo $menu; ?> <span class="three__icon"></span>
					</div>
				</div>
				<div class="add__three madclear">
					<?php 
					    echo '<div class="head__address">' . $settings['headaddress'] . '</div>';
					?>
					<div class="icon_header">
				    	<?php
					    	foreach ( $settings['social_items'] as $index => $item ) {
								$repeater_setting_key = $this->get_repeater_setting_key( 'socialicon', 'social_items', $index );
								$this->add_render_attribute( $repeater_setting_key, 'class', 'cl-socialicon' );
								$this->add_inline_editing_attributes( $repeater_setting_key );
								if ( ! empty( $item['sociallink']['url'] ) ) {
									echo '<a href="'. esc_url( $item['sociallink']['url'] ).'">';
									\Elementor\Icons_Manager::render_icon( $item['socialicon'], [ 'aria-hidden' => 'true' ] );
									echo '</a>';
								}
							}
						?>
					</div>
				</div>
			</div>
		</div>
		
		<?php
		
	}

}