<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Prestasi1_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'prestasi1';
	}

	public function get_title() {
		return esc_html__( 'MAD : Prestasi 1', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-1' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-1 .item' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-1 .item' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_html__( 'Heading Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'head_blog',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Prestasi Sekolah', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'blog_heading',
			[
				'label' => esc_html__( 'Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr1_head',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 32,
						],
					],
				],
			]
		);
		$this->add_control(
			'head_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .pr1_head' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'subhead_blog',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Sekolah kami mencetak banyak prestasi membanggakan', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'blog_subheading',
			[
				'label' => esc_html__( 'Sub Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subhead_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr1_subhead',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 20,
						],
					],
				],
			]
		);
		$this->add_control(
			'subhead_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .pr1_subhead' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'head_gap',
			[
				'label' => esc_html__( 'Right Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .pr1_head, {{WRAPPER}} .pr1_subhead' => 'padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'prt_section',
			[
				'label' => esc_html__( 'Title Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'pr_title',
			[
				'label' => esc_html__( 'Title Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#555555',
				'selectors' => [
					'{{WRAPPER}} .pr1-title' => 'color: {{VALUE}};'
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'prtitle_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr1-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 25,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 20,
						],
					],
				],
			]
		);
		$this->add_control(
			'pr_number',
			[
				'label' => esc_html__( 'Number Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#888888',
				'selectors' => [
					'{{WRAPPER}} .pr1-title:before' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'numtitle_typo',
				'label' => esc_html__( 'Number Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr1-title:before',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 90,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 90,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 50,
						],
					],
				],
			]
		);
		$this->add_responsive_control(
			'title_gap',
			[
				'label' => esc_html__( 'Right Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .pr1-title' => 'padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'prbt_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffcc33',
				'selectors' => [
					'{{WRAPPER}} .pr1-link a, {{WRAPPER}} .press1.owl-theme .owl-dots .owl-dot.active span' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'prbt_color',
			[
				'label' => esc_html__( 'Text Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .pr1-link a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'prbt_family',
			[
				'label' => esc_html__( 'Font Family', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::FONT,
				'default' => "Roboto, sans-serif",
				'selectors' => [
					'{{WRAPPER}} .pr1-link a' => 'font-family: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'image_section',
			[
				'label' => esc_html__( 'Image Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'pr1img_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr1-img img' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'pr1img_pad',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .pr1-img img' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'pr1img_rad',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .pr1-img img, .pr1-img:before, .pr1-img:after' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'pr1img_before',
			[
				'label' => esc_html__( 'Accent 1', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#eeeeee',
				'selectors' => [
					'{{WRAPPER}} .pr1-img:before' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'before_before',
			[
				'label' => esc_html__( 'Before Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .pr1-img:before' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
			]
		);
		$this->add_responsive_control(
			'before_after',
			[
				'label' => esc_html__( 'After Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .active .pr1-img:before' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => -50,
					'right' => 50,
					'bottom' => 50,
					'left' => -60,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => -50,
					'right' => 50,
					'bottom' => 50,
					'left' => -60,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => -50,
					'right' => 50,
					'bottom' => 50,
					'left' => -60,
					'unit' => 'px',
				],
			]
		);
		$this->add_control(
			'pr1img_after',
			[
				'label' => esc_html__( 'Accent 2', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#b1e6ff',
				'selectors' => [
					'{{WRAPPER}} .pr1-img:after' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'after_before',
			[
				'label' => esc_html__( 'Before Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .pr1-img:after' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 150,
					'right' => -50,
					'bottom' => -50,
					'left' => 100,
					'unit' => 'px',
				],
			]
		);
		$this->add_responsive_control(
			'after_after',
			[
				'label' => esc_html__( 'After Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .active .pr1-img:after' => 'top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
				],
				'default' => [
					'top' => 150,
					'right' => -50,
					'bottom' => -50,
					'left' => 100,
					'unit' => 'px',
				],
				'tablet_default' => [
					'top' => 150,
					'right' => -50,
					'bottom' => -50,
					'left' => 100,
					'unit' => 'px',
				],
				'mobile_default' => [
					'top' => 150,
					'right' => -50,
					'bottom' => -50,
					'left' => 100,
					'unit' => 'px',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'name_section',
			[
				'label' => esc_html__( 'Name Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'name_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr1-content' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'top_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffbb00',
				'selectors' => [
					'{{WRAPPER}} .pr1-top' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'name_family',
			[
				'label' => esc_html__( 'Name Font Family', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::FONT,
				'default' => "Roboto, sans-serif",
				'selectors' => [
					'{{WRAPPER}} .pr1-name' => 'font-family: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .pr1-name' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'accent_section',
			[
				'label' => esc_html__( 'Accent Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'acc1_color',
			[
				'label' => esc_html__( 'Accent 1 Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FFCED8',
				'selectors' => [
					'{{WRAPPER}} .span_e1' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'acc2_color',
			[
				'label' => esc_html__( 'Accent 2 Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FAD8FF',
				'selectors' => [
					'{{WRAPPER}} .span_e2' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'acc3_color',
			[
				'label' => esc_html__( 'Accent 3 Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#D9F2FF',
				'selectors' => [
					'{{WRAPPER}} .span_e3' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'acc4_color',
			[
				'label' => esc_html__( 'Accent 4 Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#FFF0C1',
				'selectors' => [
					'{{WRAPPER}} .span_e4' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		$tophead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		$bothead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		?>
		    <div class="prestasi-block-1">
			    <div class="madding_effect_1">
				    <div class="effect_1_container">
					    <span class="span_e1"></span>
						<span class="span_e2"></span>
						<span class="span_e3"></span>
						<span class="span_e4"></span>
					</div>
				</div>
			    <div class="pr_block">
			    <?php // query
					query_posts( array( 
	                    'post_type' => 'prestasi', 
						'ignore_sticky_posts' => 1,
				    	'posts_per_page' => 10,
						'orderby' => 'rand',
			            ) 
	            	);
					
					if (have_posts()) {
						$numb = 0;
						echo '<div class="press1 owl-carousel owl-theme">';
				        while (have_posts()): the_post(); 
						$numb++;
						global $post;
						$peraih = get_post_meta($post->ID, '_peraih', true);
						$photo = get_post_meta($post->ID, '_photo', true);
						    ?>
					        <div class="item pr1-loop madclear">
							    <div class="pr1_right">
								    <?php if (has_post_thumbnail()) { ?>
			    			        	<div class="pr1-img">
				    				    	<?php the_post_thumbnail('news'); ?>
				    			    	</div>
				    		    	<?php } else { ?>
					     		    	<div class="pr1-img">
											<?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			            		    	</div>
					    	    	<?php } ?>
									<div class="pr1-content">
									    <div class="madclear">
										    <div class="pr1-avatar">
										        <?php 
										    	if ( $photo != "" ) {
											    	$photoid = attachment_url_to_postid( $photo);
											    	$showphoto = wp_get_attachment_image_url( $photoid, 'thumbnail' );
											    	echo '<img src="'. esc_url( $showphoto ) .'"/>';
										    	} 
										    	?> 
											</div>
											<div class="pr1-postauthor">
											    <div class="pr1-top"><i class="icon-mad-star"></i> <i class="icon-mad-star"></i> <i class="icon-mad-star"></i> <i class="icon-mad-star"></i> <i class="icon-mad-star"></i></div>
												<div class="pr1-name"><?php echo $peraih; ?></div>
											</div>
										</div>
									</div>
								</div>
								<div class="pr1_left">
								    <div class="pr1_leftinner">
							        	<<?php echo $tophead[ $settings['blog_heading'] ]; ?> class="pr1_head"><?php echo $settings['head_blog']; ?></<?php echo $tophead[ $settings['blog_heading'] ]; ?>>
					                    <<?php echo $bothead[ $settings['blog_subheading'] ]; ?> class="pr1_subhead"><?php echo $settings['subhead_blog']; ?></<?php echo $bothead[ $settings['blog_subheading'] ]; ?>>
					                    <div class="pr1-title prt<?php echo $numb; ?>"><?php the_title(); ?></div>
								    	<div class="pr1-link"><a href="<?php the_permalink(); ?>">Selengkapnya</a></div>
									</div>
								</div>
					    	</div>
							
							
							<?php 
						endwhile;
						echo '</div>';
					}
					
			    	wp_reset_query(); 
			    ?>
			    </div>
			</div>
			<script>
            jQuery(document).ready(function($) {
                var owl = $('.press1');
                owl.owlCarousel({
                    loop: true,
                    nav: false,
					dots: true,
                    lazyLoad: true,
			    	autoplay: false,
					animateIn: 'fadeIn',
					animateOut: 'fadeOut',
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: true,
					autoHeight:true,
                    margin: 30,
			    	items: 1,    
                });
            });
            </script>
		<?php
	}

}