<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Prestasi2_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'prestasi2';
	}

	public function get_title() {
		return esc_html__( 'MAD : Prestasi 2', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'post' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'block_section',
			[
				'label' => esc_html__( 'Block Setting', 'sekolahpro' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'block_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#eff4fa',
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'padding_top',
			[
				'label' => esc_html__( 'Inner Top Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'padding_bot',
			[
				'label' => esc_html__( 'Inner Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 10,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'blockacc_bg',
			[
				'label' => esc_html__( 'Accent Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2:after' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'blokacc_width',
			[
				'label' => esc_html__( 'Accent Width', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 30,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 30,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2:after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'blockacc_angle',
			[
				'label' => esc_html__( 'Accent Angle', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 90,
				],
				'tablet_default' => [
					'unit' => '%',
					'size' => 90,
				],
				'mobile_default' => [
					'unit' => '%',
					'size' => 90,
				],
				'selectors' => [
					'{{WRAPPER}} .prestasi-block-2:after' => 'clip-path: polygon(0 0%, 100% 0%, {{SIZE}}{{UNIT}} 100%, 0% 100%);',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_html__( 'Heading Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'head_press',
			[
				'label' => esc_html__( 'Heading', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Prestasi Sekolah', 'sekolahpro' ),
			]
		);
		$this->add_control(
			'pr2_head',
			[
				'label' => esc_html__( 'Heading Tag', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__( 'H1', 'sekolahpro' ),
					'h2' => esc_html__( 'H2', 'sekolahpro' ),
					'h3' => esc_html__( 'H3', 'sekolahpro' ),
					'h4' => esc_html__( 'H4', 'sekolahpro' ),
					'h5' => esc_html__( 'H5', 'sekolahpro' ),
					'h6' => esc_html__( 'H6', 'sekolahpro' ),
					'div' => esc_html__( 'div', 'sekolahpro' ),
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'label' => esc_html__( 'Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr2_head',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Roboto',
					],
					'font_weight' => [
				    	'default' => 700,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 40,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 40,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 22,
						],
					],
				],
			]
		);
		$this->add_control(
			'head_color',
			[
				'label' => esc_html__( 'Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .pr2_head' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_bg',
			[
				'label' => esc_html__( 'Link Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr2_head a' => 'background: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_border',
			[
				'label' => esc_html__( 'Link Border Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr2_head a' => 'border-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'headlink_color',
			[
				'label' => esc_html__( 'Link Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .pr2_head a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'headlink_padding',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'tablet_default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'mobile_default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2_head a' => 'padding: 0 {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'headlink_radius',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2_head a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'head_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2_head' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'prescon_section',
			[
				'label' => esc_html__( 'Box Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'prescon_bg',
			[
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr2-loop, {{WRAPPER}} .pr2-loop .avatar' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'prescon_pad',
			[
				'label' => esc_html__( 'Padding', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2-loop' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'prescon_rad',
			[
				'label' => esc_html__( 'Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2-loop' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'cont_section',
			[
				'label' => esc_html__( 'Content Section', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_responsive_control(
			'conimg_rad',
			[
				'label' => esc_html__( 'Image Border Radius', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .pr2-img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typo',
				'label' => esc_html__( 'Name Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr2-names',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 14,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 14,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 13,
						],
					],
				],
			]
		);
		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Name Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .pr2-names' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pr2title_typo',
				'label' => esc_html__( 'Publish Typography', 'sekolahpro' ),
				'selector' => '{{WRAPPER}} .pr2-title',
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'fields_options' => [
			    	'font_family' => [
				    	'default' => 'Poppins',
					],
					'font_weight' => [
				    	'default' => 400,
					],
					'line_height' => [
				    	'default' =>  [
						    'unit' => 'em',
							'size' => 1.2,
						],
					],
					'font_size'   => [
				    	'default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'tablet_default' => [
						    'unit' => 'px',
							'size' => 16,
						],
						'mobile_default' => [
						    'unit' => 'px',
							'size' => 14,
						],
					],
				],
			]
		);
		$this->add_control(
			'pr2title_color',
			[
				'label' => esc_html__( 'Title Color', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .pr2-title a' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unic = $this->get_unique_selector();
		$tophead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		$bothead = [
			'h1' => 'h1',
			'h2' => 'h2',
			'h3' => 'h3',
			'h4' => 'h4',
			'h5' => 'h5',
			'h6' => 'h6',
			'div' => 'div',
		];
		?>
		    <div class="prestasi-block-2">
			    <div class="pr2_block">
			    <?php // query
					query_posts( array( 
	                    'post_type' => 'prestasi', 
						'ignore_sticky_posts' => 1,
				    	'posts_per_page' => 10,
						'orderby' => 'rand',
			            ) 
	            	);
					
					echo '<'. $tophead[ $settings['pr2_head'] ] .' class="pr2_head">'. $settings['head_press'] .' <a href="'. get_post_type_archive_link( 'prestasi' ) .'">Lihat Semua</a></'. $tophead[ $settings['pr2_head'] ] .'>';
						
					if (have_posts()) {
						echo '<div class="pr2-inner">';
						echo '<div class="press2 owl-carousel owl-theme">';
				        while (have_posts()): the_post(); 
						global $post;
						$peraih = get_post_meta($post->ID, '_peraih', true);
						$photo = get_post_meta($post->ID, '_photo', true);
						    ?>
					        <div class="item pr2-loop">
								    <?php if (has_post_thumbnail()) { ?>
			    			        	<a class="pr2-img" href="<?php the_permalink() ?>">
				    				    	<?php the_post_thumbnail('news'); ?>
				    			    	</a>
				    		    	<?php } else { ?>
					     		    	<a class="pr2-img" href="<?php the_permalink() ?>">
											<?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			            		    	</a>
					    	    	<?php } ?>
									<div class="pr2-content">
									    <div class="madclear pr2-author">
										    <?php 
										    	if ( $photo != "" ) {
											    	$photoid = attachment_url_to_postid( $photo);
											    	$showphoto = wp_get_attachment_image_url( $photoid, 'thumbnail' );
											    	echo '<img class="avatar" src="'. esc_url( $showphoto ) .'"/>';
										    	} 
											?> 
											<div class="pr2-names"><?php echo $peraih; ?></div>
											<h3 class="pr2-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									        <a class="pr2-read" href="<?php the_permalink(); ?>"><span></span></a>
										</div>
									</div>
					    	</div>
							
							
							<?php 
						endwhile;
						echo '</div>';
						echo '</div>';
					}
					
			    	wp_reset_query(); 
			    ?>
			    </div>
			</div>
			<script>
            jQuery(document).ready(function($) {
                var owl = $('.press2');
                owl.owlCarousel({
                    loop: true,
                    nav: true,
					navText: ["<span class='icon-mad-left'></span>","<i class='icon-mad-right'></span>"],
					dots: false,
                    lazyLoad: true,
			    	autoplay: true,
                    autoplayTimeout: 5000,
                    smartSpeed: 1500,
                    autoplayHoverPause: true,
                    margin: 20,
			    	responsive:{
                        0:{ 
				    	    items:2,
                        },
                        640:{
                            items:2
                        },
                        982:{
                            items:4
                        }
                    }    
                });
            });
            </script>
		<?php
	}

}