<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Theme_NewsEditorial_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'themesnewseditor';
	}

	public function get_title() {
		return esc_html__( 'MAD : News + Editorial', 'sekolahpro' );
	}
	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Slider Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'countperslide',
			[
				'label' => esc_html__( 'Count Per Slide', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 30,
				'step' => 1,
				'default' => 5,
			]
		);
		$this->add_control(
			'animatein',
			[
				'label' => esc_html__( 'Animate In', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeIn',
				'options' => [
					'fadeIn' => esc_html__( 'Fade In', 'sekolahpro' ),
					'slideInDown' => esc_html__( 'Slide In Down', 'sekolahpro' ),
					'slideInLeft' => esc_html__( 'Slide In Left', 'sekolahpro' ),
					'slideInRight' => esc_html__( 'Slide In Right', 'sekolahpro' ),
					'slideInUp' => esc_html__( 'Slide In Up', 'sekolahpro' ),
					'flipInX' => esc_html__( 'Flip In X', 'sekolahpro' ),
					'zoomIn' => esc_html__( 'Zoom In', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'animateout',
			[
				'label' => esc_html__( 'Animate Out', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeOut',
				'options' => [
					'fadeOut' => esc_html__( 'Fade Out', 'sekolahpro' ),
					'slideOutDown' => esc_html__( 'Slide Out Down', 'sekolahpro' ),
					'slideOutLeft' => esc_html__( 'Slide Out Left', 'sekolahpro' ),
					'slideOutRight' => esc_html__( 'Slide Out Right', 'sekolahpro' ),
					'slideOutUp' => esc_html__( 'Slide Out Up', 'sekolahpro' ),
					'flipOutX' => esc_html__( 'Flip Out X', 'sekolahpro' ),
					'zoomOut' => esc_html__( 'Zoom Out', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'smartspeed',
			[
				'label' => esc_html__( 'Change Speed', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 50,
				'max' => 2000,
				'step' => 50,
				'default' => 450,
			]
		);
		$this->add_control(
			'autotimeout',
			[
				'label' => esc_html__( 'Duration Per Slide', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 3000,
				'max' => 8000,
				'step' => 1000,
				'default' => 5000,
			]
		);
		
		$this->add_control(
			'text_align',
			[
				'label' => esc_html__( 'Box Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left_align' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center_align' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right_align' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center_align',
				'toggle' => true,
			]
		);
		
		$this->add_responsive_control(
			'pos_bottom',
			[
				'label' => esc_html__( 'Bottom Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 150,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .box_comproslider' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'overlay_bg',
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'types' => [ 'gradient' ],
				'exclude' => [ 'color_stop', 'color_b_stop' ],
				'selector' => '{{WRAPPER}} .comproslide_overlay',
			]
		);
		
		$this->add_control(
			'opacity_bg',
			[
				'label' => esc_html__( 'Opacity', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0.5,
				],
				'selectors' => [
					'{{WRAPPER}} .comproslide_overlay' => 'opacity: {{SIZE}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_position',
			[
				'label' => esc_html__( 'Image Position in Mobile (%)', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					],
				],
				'devices' => [ 'mobile' ],
				'mobile_default' => [
					'size' => 150,
				],
				'selectors' => [
					'.is_small {{WRAPPER}} .comproslide img' => 'margin-left: -{{SIZE}}%;',
				],
			]
		);
		
		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
	    	<div class="ext_container">
    <div class="mad_news">
	    <div class="title_news re_news"><?php mading_re_news(); ?></div>
	    <div class="news_before madclear">
	    	<?php // query
		    	$args = array(
			        'post_type' => 'post', 
			        'posts_per_page' => 4, 
		        );
	    	    query_posts($args);
				
				if (have_posts()) {
					while (have_posts()): the_post(); 
					global $post;
					?>
					
					<div class="news_home_loop">
						<div class="news_box">
					    	<?php 
							    if (has_post_thumbnail()) { 
								?>
						        	<a href="<?php the_permalink() ?>" class="mad_news_thumb">
										<?php 
											the_post_thumbnail('news', array(
												'alt' => trim(wp_strip_all_tags($post->post_title)),
											    'title' => trim(wp_strip_all_tags($post->post_title)),
											)); 
										?>
								    </a>
							    <?php } else { ?>
								    <a href="<?php the_permalink() ?>" class="mad_news_thumb">
			    	    		            <?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			        			    </a>
							    <?php 
								} 
							?>
							<div class="news_meta">
							    <div class="news_auth"><span class="post-date"><?php echo esc_html( get_the_time('l, j F Y') ); ?></span></div>
						    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
							</div>
						</div>
					</div>
							
					<?php 
					endwhile;
				} 
				
			wp_reset_query(); 
		?>
    	</div>
	</div>
	<div class="mad_editorial">
	    <div class="title_news re_editor"><?php mading_re_editorial(); ?></div>
	    <div class="edit_before">
		    <div class="mad_master">
			    <div class="get_master">
			        <div class="get_photos"><?php mading_get_photos(); ?></div>
					<div class="get_names">
				    	<div class="head_name"><?php mading_kepala_sekolah(); ?></div>
						<div class="re_kepala"><?php mading_re_kepsek(); ?></div>
					</div>
				</div>
			</div>
			<div class="edit_post">
		    	<?php // query
			    	$args = array(
			            'post_type' => 'editorial', 
			            'posts_per_page' => 5, 
		            );
		            query_posts($args);
					
					if (have_posts()) {
				    	while (have_posts()): the_post(); 
				    	?>
						
						<div class="edit_home_loop">
					    	<div class="edit_box">
						    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
							</div>
						</div>
						
						<?php 
				    	endwhile;
			    	} 
					
					wp_reset_query(); 
				?>
			</div>
		</div>
	</div>
</div>
		<?php
	}

	protected function content_template() {
		?>
	    	<div class="ext_container">
    <div class="mad_news">
	    <div class="title_news re_news"><?php mading_re_news(); ?></div>
	    <div class="news_before madclear">
	    	<?php // query
		    	$args = array(
			        'post_type' => 'post', 
			        'posts_per_page' => 4, 
		        );
	    	    query_posts($args);
				
				if (have_posts()) {
					while (have_posts()): the_post(); 
					?>
					
					<div class="news_home_loop">
						<div class="news_box">
					    	<?php 
							    if (has_post_thumbnail()) { 
								?>
						        	<a href="<?php the_permalink() ?>" class="mad_news_thumb">
										<?php 
											the_post_thumbnail('news', array(
												'alt' => trim(wp_strip_all_tags($post->post_title)),
											    'title' => trim(wp_strip_all_tags($post->post_title)),
											)); 
										?>
								    </a>
							    <?php } else { ?>
								    <a href="<?php the_permalink() ?>" class="mad_news_thumb">
			    	    		            <?php if ( get_theme_mod('madingthumb_image') != "" ) {
												$normal = attachment_url_to_postid( get_theme_mod('madingthumb_image'));
												$shownormal = wp_get_attachment_image_url( $normal, 'news' );
												echo '<img src="'. esc_url( $shownormal ) .'"/>';
											} else {
			    	        		            echo '<img src="'. esc_url( get_template_directory_uri() ).'/images/mading.jpg"/>';
											} ?>
			        			    </a>
							    <?php 
								} 
							?>
							<div class="news_meta">
							    <div class="news_auth"><span class="post-date"><?php echo esc_html( get_the_time('l, j F Y') ); ?></span></div>
						    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
							</div>
						</div>
					</div>
							
					<?php 
					endwhile;
				} 
				
			wp_reset_query(); 
		?>
    	</div>
	</div>
	<div class="mad_editorial">
	    <div class="title_news re_editor"><?php mading_re_editorial(); ?></div>
	    <div class="edit_before">
		    <div class="mad_master">
			    <div class="get_master">
			        <div class="get_photos"><?php mading_get_photos(); ?></div>
					<div class="get_names">
				    	<div class="head_name"><?php mading_kepala_sekolah(); ?></div>
						<div class="re_kepala"><?php mading_re_kepsek(); ?></div>
					</div>
				</div>
			</div>
			<div class="edit_post">
		    	<?php // query
			    	$args = array(
			            'post_type' => 'editorial', 
			            'posts_per_page' => 5, 
		            );
		            query_posts($args);
					
					if (have_posts()) {
				    	while (have_posts()): the_post(); 
				    	?>
						
						<div class="edit_home_loop">
					    	<div class="edit_box">
						    	<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
							</div>
						</div>
						
						<?php 
				    	endwhile;
			    	} 
					
					wp_reset_query(); 
				?>
			</div>
		</div>
	</div>
</div>
		<?php
	}

}

