<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Elementor_Theme_Slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'themeslider';
	}

	public function get_title() {
		return esc_html__( 'MAD : Slider', 'sekolahpro' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_custom_help_url() {
		return 'https://developers.elementor.com/docs/widgets/';
	}

	public function get_categories() {
		return [ 'mading-widget' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Slider Setting', 'sekolahpro' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'countperslide',
			[
				'label' => esc_html__( 'Count Per Slide', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 30,
				'step' => 1,
				'default' => 5,
			]
		);
		$this->add_control(
			'animatein',
			[
				'label' => esc_html__( 'Animate In', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeIn',
				'options' => [
					'fadeIn' => esc_html__( 'Fade In', 'sekolahpro' ),
					'slideInDown' => esc_html__( 'Slide In Down', 'sekolahpro' ),
					'slideInLeft' => esc_html__( 'Slide In Left', 'sekolahpro' ),
					'slideInRight' => esc_html__( 'Slide In Right', 'sekolahpro' ),
					'slideInUp' => esc_html__( 'Slide In Up', 'sekolahpro' ),
					'flipInX' => esc_html__( 'Flip In X', 'sekolahpro' ),
					'zoomIn' => esc_html__( 'Zoom In', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'animateout',
			[
				'label' => esc_html__( 'Animate Out', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'fadeOut',
				'options' => [
					'fadeOut' => esc_html__( 'Fade Out', 'sekolahpro' ),
					'slideOutDown' => esc_html__( 'Slide Out Down', 'sekolahpro' ),
					'slideOutLeft' => esc_html__( 'Slide Out Left', 'sekolahpro' ),
					'slideOutRight' => esc_html__( 'Slide Out Right', 'sekolahpro' ),
					'slideOutUp' => esc_html__( 'Slide Out Up', 'sekolahpro' ),
					'flipOutX' => esc_html__( 'Flip Out X', 'sekolahpro' ),
					'zoomOut' => esc_html__( 'Zoom Out', 'sekolahpro' ),
				],
			]
		);
		$this->add_control(
			'smartspeed',
			[
				'label' => esc_html__( 'Change Speed', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 50,
				'max' => 2000,
				'step' => 50,
				'default' => 450,
			]
		);
		$this->add_control(
			'autotimeout',
			[
				'label' => esc_html__( 'Duration Per Slide', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 3000,
				'max' => 8000,
				'step' => 1000,
				'default' => 5000,
			]
		);
		
		$this->add_control(
			'text_align',
			[
				'label' => esc_html__( 'Box Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left_align' => [
						'title' => esc_html__( 'Left', 'sekolahpro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center_align' => [
						'title' => esc_html__( 'Center', 'sekolahpro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right_align' => [
						'title' => esc_html__( 'Right', 'sekolahpro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center_align',
				'toggle' => true,
			]
		);
		
		$this->add_responsive_control(
			'pos_bottom',
			[
				'label' => esc_html__( 'Bottom Position', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 150,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .box_comproslider' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'overlay_bg',
				'label' => esc_html__( 'Background', 'sekolahpro' ),
				'types' => [ 'gradient' ],
				'exclude' => [ 'color_stop', 'color_b_stop' ],
				'selector' => '{{WRAPPER}} .comproslide_overlay',
			]
		);
		
		$this->add_control(
			'opacity_bg',
			[
				'label' => esc_html__( 'Opacity', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0.5,
				],
				'selectors' => [
					'{{WRAPPER}} .comproslide_overlay' => 'opacity: {{SIZE}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_position',
			[
				'label' => esc_html__( 'Image Position in Mobile (%)', 'sekolahpro' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					],
				],
				'devices' => [ 'mobile' ],
				'mobile_default' => [
					'size' => 150,
				],
				'selectors' => [
					'.is_small {{WRAPPER}} .comproslide img' => 'margin-left: -{{SIZE}}%;',
				],
			]
		);
		
		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$args = array(
			    'post_type' => 'slider', 
			    'posts_per_page' => $settings['countperslide'], 
		    );
		    query_posts($args);
			
			if (have_posts()) {
	        	?>
				<div class="comproslide owl-carousel owl-theme">
				<?php 
				    while (have_posts()): the_post(); 
					global $post;
					$extlink = get_post_meta($post->ID, '_extlink', true);
					?>
					
				    	<div class="item">
							<?php 
							    if ( $extlink != '' ) { 
								?>
							    <a href="<?php echo esc_url( $extlink ); ?>">
							    <?php 
								} 
							    if (has_post_thumbnail()) {
									the_post_thumbnail('slider'); 
								}
								if ( $extlink != '' ) { ?>
							    </a>
								<?php 
								} 
							?>
						</div>
					
					<?php
					endwhile;
				?>
	        	</div>
				<?php
			}
		wp_reset_query();
		?>
		<script>
			jQuery(document).ready(function($) {
              var owl = $('.comproslide');
              owl.owlCarousel({
                loop: true,
				margin: 0,
                responsiveClass:true,
				animateOut: '<?php echo $settings['animateout']; ?>',
				animateIn: '<?php echo $settings['animatein']; ?>',
				smartSpeed: <?php echo $settings['smartspeed']; ?>,
				autoplayTimeout: <?php echo $settings['autotimeout']; ?>,
                nav: false,
				dots: false,
                lazyLoad: true,
				autoplay: true,
				items:1  
              });
            });
		</script>
		<?php
	}


}

